(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    184065,       6263]*)
(*NotebookOutlinePosition[    185879,       6320]*)
(*  CellTagsIndexPosition[    185767,       6313]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\<\
Chapter 1
Introduction\
\>", "Title",
  TextAlignment->Left,
  TextJustification->1],

Cell["For convenience we turn off the spell checker by typing", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Off[General::spell1]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell["1.1 Preliminary Remarks", "Section",
  CellMargins->{{10.75, 24.125}, {Inherited, Inherited}},
  Evaluatable->False,
  CellLabelMargins->{{11.5625, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{"ChapterOne", "ChapterOne.1"}],

Cell[TextData[{
  "Many vibration problems in engineering are nonlinear in nature. The usual \
linear analysis may be inadequate for many applications. An essential \
difference in the study of nonlinear systems is that general solutions cannot \
be obtained by superposition, as in the case of linear systems. Moreover, the \
nonlinearity brings many new phenomena, which do not occur in linear systems. \
To study nonlinear systems, one has to learn new mathematical techniques, \
which have been developed in many branches of applied mathematics, physics, \
and engineering. In the past several years, a number of powerful computer \
software packages have been developed that allow one to perform complicated \
symbolic manipulations. One of the best known is ",
  StyleBox["Mathematica;",
    FontSlant->"Italic"],
  " it is created by Wolfram Research, Inc.. In this book, we use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s symbolic programming techniques to implement various perturbation \
methods for studying the dynamics of weakly nonlinear systems. Instead of \
being burdened by the tedious algebra required to obtain the solutions, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " enables us to focus our attention on understanding the techniques and the \
physics, thereby free our time for creative thinking."
}], "Text",
  TextAlignment->Left,
  TextJustification->1,
  FontSize->12],

Cell[TextData[{
  "Symbolic manipulators are powerful tools. They can be used to perform \
analyses in either an interactive or an automatic way. Learning ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " in the process of studying perturbation methods should enhance the \
concepts of ",
  StyleBox["Mathematica",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[" programming techniques",
    FontColor->RGBColor[0, 0, 1]],
  " as well as various ",
  StyleBox["perturbation techniques",
    FontColor->RGBColor[0, 0, 1]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1,
  FontSize->12],

Cell["\<\
In Chapter 2, we describe how various perturbation methods, such as the \
Lindstedt-Poincar\[EAcute] technique, the method of multiple scales, and the \
method of averaging, can be used to obtain uniform asymptotic expansions of \
the solutions of the undamped and unforced Duffing equation. In Chapter 3, we \
apply the Lindstedt-Poincar\[EAcute] technique, the method of multiple \
scales, the method of averaging, the generalized method of averaging, the \
Krylov-Bogoliubov-Mitropolsky technique, and the method of normal forms to \
obtain uniform expansions of the solutions of an undamped and unforced \
single-degree-of-freedom oscillator with quadratic and cubic \
nonlinearities.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
In Chapter 4, we use the method of multiple scales, the generalized method of \
averaging, and the method of normal forms to obtain uniform expansions of the \
solutions of a forced single-degree-of-freedom oscillator with quadratic and \
cubic nonlinearities. In Chapter 5, we apply the method of multiple scales, \
the method of normal forms, and the generalized method of averaging to study \
higher-order approximations for systems with internal resonances. In Chapter \
6, we apply the method of multiple scales to obtain uniform expansions of the \
solutions of externally and parametrically excited linearly coupled or \
uncoupled multiple-degree-of-freedom systems.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
In Chapter 7, we focus our attention on continuous systems with cubic \
nonlinearities. In Section 7.1, we discuss the concepts of adjoint and \
solvability conditions. Then, we use the method of multiple scales to \
construct uniformly valid asymptotic expansions of the solutions of \
hinged-clamped beams in Section 7.2 and cantilever beams in Section 7.3. In \
Chapter 8, we use the method of multiple scales to directly attack three \
continuous systems with quadratic and cubic nonlinearities. We treat buckled \
beams in Section 8.1, circular cylindrical shells in Section 8.2, and \
near-square plates in Section 8.3.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
In Chapter 9, we show how one can use the method of multiple scales to \
construct higher-order approximations of the solutions of continuous systems \
having two-to-one internal resonances. We discuss two-mode interactions in \
buckled beams in Section 9.1 and four-mode interactions in suspended cables \
in Section 9.2.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2 Symbolic Computation", "Section",
  CellMargins->{{10.75, 24.125}, {Inherited, Inherited}},
  Evaluatable->False,
  CellLabelMargins->{{11.5625, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  AspectRatioFixed->True,
  CellTags->{"ChapterOne", "ChapterOne.1"}],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming language allows not only for interactive manipulations of a \
wide range of objects, but it also encourages the automation of complicated \
computations. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " actually works by using systems of rewrite rules, and the user can freely \
create and use his or her own systems of rules. This distinguishes it from \
traditional programming languages, which normally have no such features. We \
have applied rule-based and functional programming techniques in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " throughout this book. Hence, we briefly cover the basic ingredients of \
rule-based programming in Sections 1.2.1--1.2.5 and some functional \
programming features in Sections 1.2.6--1.2.8."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "For further information on ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", consult the standard ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " reference: ",
  StyleBox["The Mathematica Book",
    FontSlant->"Italic"],
  ", Stephen Wolfram, Third Edition, Wolfram Media and Cambridge University \
Press, 1996. Full descriptions of the functions in the standard ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " packages are available in ",
  StyleBox["Mathematica 3.0 Standard Add-On Packages manual,",
    FontSlant->"Italic"],
  " Wolfram Media and Cambridge University Press, 1996. Alternatively, simply \
click on the Help menu to view the Help Browser."
}], "Text",
  CellFrame->True,
  TextAlignment->Left,
  TextJustification->1,
  Background->RGBColor[0, 1, 1]],

Cell[TextData[{
  "In the Text cells of this book, we use ",
  StyleBox["bold-magenta",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " to indicate ",
  StyleBox["user-defined functions",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " or ",
  StyleBox["names",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["bold-black",
    FontWeight->"Bold"],
  " to indicate ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s ",
  StyleBox["built-in functions",
    FontWeight->"Bold"],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell["1.2.1 Global Rules", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Global rules are applied whenever the appropriate left-hand side is \
encountered or matched. The advantage of using global rules is that one does \
not need to apply explicitly a rule to get things done. However, it is almost \
impossible to prevent such global rules from being applied to a certain \
expression. There are two types of user-defined global rewrite rules: those \
using ",
  Cell[BoxData[
      FormBox[
        StyleBox["=",
          FontWeight->"Bold"], TraditionalForm]]],
  " and those using ",
  Cell[BoxData[
      FormBox[
        StyleBox[":=",
          FontWeight->"Bold"], TraditionalForm]]],
  ". The distinction between them lies in ",
  StyleBox["when ",
    FontColor->RGBColor[0, 0, 1]],
  "the right-hand side is evaluated. Moreover, each of these rules has two \
forms, depending on ",
  StyleBox["where",
    FontColor->RGBColor[0, 0, 1]],
  " the rule is stored, resulting in four rules indicated by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["=",
            FontWeight->"Bold"], 
          RowBox[{",", 
            RowBox[{
              StyleBox["^=",
                FontWeight->"Bold"], 
              RowBox[{",", 
                RowBox[{
                  StyleBox[":=",
                    FontWeight->"Bold"], 
                  RowBox[{",", " ", 
                    RowBox[{"and", " ", 
                      StyleBox["^:=",
                        FontWeight->"Bold"]}]}]}]}]}]}]}], 
        TraditionalForm]]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[TextData[{
  "1.2.1.1   ",
  Cell[BoxData[
      \(TraditionalForm\` = \)]],
  " rules"
}], "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "We can think of ",
  Cell[BoxData[
      \(TraditionalForm\` = \)]],
  ", an assignment statement in analogy with traditional procedural \
programming languages, as a (global) rewrite rule. The characteristic \
property of using the rule ",
  Cell[BoxData[
      FormBox[
        StyleBox["=",
          FontWeight->"Bold"], TraditionalForm]]],
  " is that the right-hand side is evaluated immediately when the assignment \
is made, and all subsequent matched left-hand sides are replaced by the \
evaluated right-hand side. For example, let us consider the rule"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(a = 2; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The output is suppressed by ending the input with a semicolon. From now \
on, whenever ",
  StyleBox["a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " is encountered in any expression, ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "will replace it by its value 2."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(expr1 = a\^2 + 3 - a + Tan[a]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(5 + Tan[2]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Let us try to evaluate ",
  StyleBox["expr1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " for another value,"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(a = 3; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(expr1\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(5 + Tan[2]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The new value of ",
  StyleBox["a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " is not recognized in ",
  StyleBox["expr1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Let us try to clear the definition of ",
  StyleBox["a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " by using ",
  StyleBox["Clear",
    FontWeight->"Bold"],
  " or"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(a =. \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Then, let us evaluate ",
  StyleBox["expr1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ","
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(expr1\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(5 + Tan[2]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Again, ",
  StyleBox["expr1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " is not changed accordingly."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To be able to evaluate ",
  StyleBox["expr1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " for different values of ",
  StyleBox["a",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ", we need to either define ",
  StyleBox["expr1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " before the assignment of ",
  StyleBox["a ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "or use \"",
  Cell[BoxData[
      FormBox[
        StyleBox[":=",
          FontWeight->"Bold"], TraditionalForm]]],
  "\", instead of \"",
  Cell[BoxData[
      FormBox[
        StyleBox["=",
          FontWeight->"Bold"], TraditionalForm]]],
  "\". The precise meaning of ",
  Cell[BoxData[
      FormBox[
        StyleBox[":=",
          FontWeight->"Bold"], TraditionalForm]]],
  " is taken up in the next section. Here, we illustrate the former choice."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[a]; expr1 = a\^2 + 3 - a + Tan[a]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(3 - a + a\^2 + Tan[a]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a = 2; expr1\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(5 + Tan[2]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a = 3; expr1\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(9 + Tan[3]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
In traditional programming languages, the left-hand side of an assignment \
statement is required to be a simple identifier (i.e., a symbol). In computer \
algebra, the left-hand side can be arbitrarily complicated. For example,\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(look[here + 9] = Expand[\((1 + x)\)^2 + y]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(1 + 2\ x + x\^2 + y\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Note that the output of an ",
  Cell[BoxData[
      FormBox[
        StyleBox["=",
          FontWeight->"Bold"], TraditionalForm]]],
  " expression is the evaluated form of the right-hand side. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " regards the left-hand side as a ",
  StyleBox["pattern",
    FontColor->RGBColor[0, 0, 1]],
  ". Whenever ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " finds ",
  StyleBox["something",
    FontSlant->"Italic"],
  " that matches this pattern, it replaces the ",
  StyleBox["something",
    FontSlant->"Italic"],
  " by the evaluated right-hand side."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(look[there + look[here + 5 + 2^2]]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(look[1 + there + 2\ x + x\^2 + y]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "In this evaluation, the pattern ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(look\ [here + 5 + 2\^2]\),
          FontWeight->"Bold",
          FontColor->RGBColor[1, 0, 1]], TraditionalForm]]],
  " simplifies to ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(look\ [here + 9]\),
          FontWeight->"Bold",
          FontColor->RGBColor[1, 0, 1]], TraditionalForm]]],
  " , which is replaced by ",
  Cell[BoxData[
      \(1 + 2\ x + x\^2 + y\)]],
  ". The resulting expression does not match any pattern involving ",
  StyleBox["look",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "and so it is left in unevaluated form. This rule is stored with ",
  StyleBox["look",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?look\)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \("Global`look"\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    InterpretationBox[
      StyleBox[\(look[9\  + \ here]\  = \ 1\  + \ 2*x\  + \ x^2\  + \ y\),
        ShowStringCharacters->True,
        NumberMarks->True],
      InputForm[ 
        Definition[ look]],
      Editable->True,
      AutoDelete->True]], "Print",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["Again, we see the evaluated form on the right-hand side.", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
There are some problems associated with left-hand sides that are not symbols. \
For example, suppose we try to make the following rule:\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(x + y = z\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Set::"write" \( : \ \) 
      "Tag \!\(Plus\) in \!\(x + y\) is Protected."\)], "Message",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(z\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "We get an error message stating that ",
  StyleBox["Plus",
    FontWeight->"Bold"],
  " is protected, which means new rules cannot be added for ",
  StyleBox["Plus",
    FontWeight->"Bold"],
  ". Every time ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " encounters ",
  StyleBox["Plus",
    FontWeight->"Bold"],
  ", it searches through the rules for ",
  StyleBox["Plus",
    FontWeight->"Bold"],
  " to see if anything applies. If we add a new rule for ",
  StyleBox["Plus",
    FontWeight->"Bold"],
  ", then that rule would have to be examined at every subsequent addition. \
When a rule of the form ",
  Cell[BoxData[
      \(TraditionalForm\`x + y = z\)]],
  " is given, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " interprets it as a rule of the form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["Plus",
              FontWeight->"Bold"], "[", \(x, y\), "]"}], "=", "z"}], 
        TraditionalForm]]],
  ". Rules have to be stored somewhere and the default rule is that for the \
head of the left-hand side. One way of adding  a new rule for ",
  StyleBox["Plus ",
    FontWeight->"Bold"],
  "is to unprotect ",
  StyleBox["Plus",
    FontWeight->"Bold"],
  ", make the rule, and then reprotect it."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Unprotect[Plus]; \nx + y = z; \nProtect[Plus]; \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Now whenever ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sees ",
  Cell[BoxData[
      \(TraditionalForm\`x + y\)]],
  ", it rewrites it as ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(x + s + y + t\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(s + t + z\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Alternatively, we can use ",
  StyleBox["UpValues",
    FontWeight->"Bold"],
  " to associate the rule with the unprotected argument of the left-hand \
side. (Definitions that attach a value to the head of the left-hand side are \
called ",
  StyleBox["DownValues",
    FontWeight->"Bold"],
  " of the head.) For example,"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(s + t ^= u\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(u\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Note the caret ",
  Cell[BoxData[
      \(TraditionalForm\`^\)]],
  " before the ",
  Cell[BoxData[
      \(TraditionalForm\` = \)]],
  " sign. This rule is associated with the symbol ",
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  " or ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?s\)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \("Global`s"\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    InterpretationBox[
      StyleBox[\(s /: \ s\  + \ t\  = \ u\),
        ShowStringCharacters->True,
        NumberMarks->True],
      InputForm[ 
        Definition[ s]],
      Editable->True,
      AutoDelete->True]], "Print",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(t + s + t\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(t + u\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "A given symbol can have both up and down values. Let's give ",
  StyleBox["s",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " a down value in addition to the up value it already has."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(s[x_] := Exp[I\ a\ x]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Then looking at ",
  StyleBox["s",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " shows both kinds of values:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?s\)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \("Global`s"\)], "Print",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    InterpretationBox[
      StyleBox[\(s /: \ s\  + \ t\  = \ \(u\n\ \ns[x_]\  := \ Exp[I*a*x]\)\),
        ShowStringCharacters->True,
        NumberMarks->True],
      InputForm[ 
        Definition[ s]],
      Editable->True,
      AutoDelete->True]], "Print",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["Finally, we can access the up and down values individually.", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({UpValues[s], DownValues[s]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{HoldPattern[s + t] \[RuleDelayed] u}, {
        HoldPattern[s[x_]] \[RuleDelayed] Exp[I\ a\ x]}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Now let us try naively define the sine function using an ",
  Cell[BoxData[
      \(TraditionalForm\` = \)]],
  " rule according to"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(m[x] = Sin[x]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "It works properly for the symbol ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " but not for anything else."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({m[x], m[y], m[1]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({Sin[x], m[y], m[1]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "This is where the special symbol _ comes in. The form ",
  Cell[BoxData[
      \(TraditionalForm\`x_\)]],
  " means a ",
  StyleBox["pattern",
    FontColor->RGBColor[0, 0, 1]],
  " named ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". We can show the internal representation of any expression, such as ",
  Cell[BoxData[
      \(TraditionalForm\`x_\)]],
  " , by either using"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[x_]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    TagBox[
      StyleBox[\(Pattern[x, Blank[]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True],
      FullForm]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["or using", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(x_ // FullForm\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    TagBox[
      StyleBox[\(Pattern[x, Blank[]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True],
      FullForm]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "An underscore _ in a pattern matches ",
  StyleBox["anything",
    FontColor->RGBColor[0, 0, 1]],
  ", so it is a dummy variable or a \"wild card\". If it appears on the \
left-hand side of \"",
  Cell[BoxData[
      \(TraditionalForm\` = \)]],
  "\" rule with a name, like ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", then the left-hand side is rewritten as the right-hand side with ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " replaced by the desired variable. Let us use this to redefine ",
  StyleBox["m",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "; that is,"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(m[x_] = Sin[x]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Now ",
  StyleBox["m",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " works for any argument:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({m[x], m[y], m[1], m[s - t]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({Sin[x], Sin[y], Sin[1], Sin[s - t]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Thus, one can use ",
  Cell[BoxData[
      \(TraditionalForm\` = \)]],
  " rules to define functions."
}], "Text",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "1.2.1.2   ",
  Cell[BoxData[
      \(TraditionalForm\` := \)]],
  " rules"
}], "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Rules using ",
  Cell[BoxData[
      \(TraditionalForm\` := \)]],
  "  do not evaluate the right-hand side immediately but instead leave it \
unevaluated until the function is actually used. They can be used with simple \
left-hand sides or with left-hand sides containing patterns. As an example, \
let us define and compare two rules using ",
  Cell[BoxData[
      \(TraditionalForm\` = \)]],
  " or ",
  Cell[BoxData[
      \(TraditionalForm\` := \)]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Clear[x]; \nlhs1 = Expand[\((x + 1)\)^2]; \n
    lhs2 := Expand[\((x + 1)\)^2]; \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["If these are evaluated, they give the same result.", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({lhs1, lhs2}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({1 + 2\ x + x\^2, 1 + 2\ x + x\^2}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "If we now give a value to ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", then ",
  StyleBox["lhs1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and ",
  StyleBox["lhs2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " will use this value in different ways."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(x = p + q; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({lhs1, lhs2}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({1 + 2\ \((p + q)\) + \((p + q)\)\^2, 
      1 + 2\ p + p\^2 + 2\ q + 2\ p\ q + q\^2}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "If the left-hand side of a ",
  Cell[BoxData[
      \(TraditionalForm\` := \)]],
  " rule contains a pattern, then on a subsequent occurrence of the left-hand \
side with actual arguments, the formal (dummy) arguments (or names of \
patterns) on the right-hand side are replaced by the actual arguments and \
then the right-hand side is evaluated. Thus, each time the left-hand side of \
such a rule matches something, it is replaced by a new evaluation of the \
right-hand side. To see the difference, we again set up the two rules"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[k_] = Expand[k^2]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(k\^2\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(g[k_] := Expand[k^2]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "We note that the right-hand side of the rule for ",
  StyleBox["f",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " is evaluated immediately when it is defined, whereas the right-hand side \
of ",
  StyleBox["g ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "is kept unevaluated. Now, try out these two definitions on the same \
value."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({f[p + q], g[p + q]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\((p + q)\)\^2, p\^2 + 2\ p\ q + q\^2}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Because the right-hand side of the rule for ",
  StyleBox["f",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " was evaluated immediately when it was defined, there is nothing to \
expand, and ",
  StyleBox["k",
    FontSlant->"Italic"],
  " is replaced with ",
  StyleBox["p+q ",
    FontSlant->"Italic"],
  "without expanding the result. On the other hand, the right-hand side of \
the rule for ",
  StyleBox["g",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " was not expanded when defined and it retains the whole expression ",
  StyleBox["Expand",
    FontWeight->"Bold"],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`k^2\)]],
  "]. When the two functions are subsequently used, ",
  Cell[BoxData[
      \(TraditionalForm\`f[p + q]\)]],
  " is just replaced by ",
  Cell[BoxData[
      \(TraditionalForm\`\((p + q)\)\^2\)]],
  ", while ",
  Cell[BoxData[
      \(TraditionalForm\`g[p + q]\)]],
  " is replaced by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["Expand",
            FontWeight->"Bold"], "[", \(\((p + q)\)^2\), "]"}], 
        TraditionalForm]]],
  " , which evaluates to ",
  Cell[BoxData[
      \(TraditionalForm\`p\^2 + 2  p\ q + q\^2\)]],
  ". The internal representation of such a definition has the following \
form:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[g[k_] := p]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    TagBox[
      StyleBox["Null",
        ShowSpecialCharacters->False,
        ShowStringCharacters->True],
      FullForm]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "To see the actual head of an expression before it is evaluated, we wrap \
the expression with ",
  StyleBox["Hold",
    FontWeight->"Bold"],
  " and then request its ",
  StyleBox["FullForm",
    FontWeight->"Bold"]
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[Hold[g[k_] := p]]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    TagBox[
      StyleBox[\(Hold[SetDelayed[g[Pattern[k, Blank[]]], p]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True],
      FullForm]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Thus, the symbol ",
  Cell[BoxData[
      \(TraditionalForm\` := \)]],
  " is the infix form of ",
  StyleBox["SetDelayed",
    FontWeight->"Bold"],
  ". This makes dramatically clear the distinction between the evaluation ",
  StyleBox["when the rule is given",
    FontColor->RGBColor[0, 0, 1]],
  " and the evaluation ",
  StyleBox["when the rule is used",
    FontColor->RGBColor[0, 0, 1]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "When the head of the left-hand side is protected, we can use ",
  StyleBox["UpValues ",
    FontWeight->"Bold"],
  "to associate the rule with the unprotected argument of the left-hand side. \
For example, when we try to differentiate a user-defined definite integral \
with constant bounds, we obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Clear[int, f, x]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[int[f[x], {x, 0, 1}], x]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["int", 
          TagBox[\((0, {1, 0, 0})\),
            Derivative],
          MultilineFunction->None], "[", \(f[x], {x, 0, 1}\), "]"}], "+", 
      RowBox[{
        RowBox[{
          SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], " ", 
        RowBox[{
          SuperscriptBox["int", 
            TagBox[\((1, {0, 0, 0})\),
              Derivative],
            MultilineFunction->None], "[", \(f[x], {x, 0, 1}\), "]"}]}]}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "which is not what we intended. We can either unprotect ",
  StyleBox["D",
    FontWeight->"Bold"],
  " and add a rule or use ",
  Cell[BoxData[
      \(TraditionalForm\` ^:= \)]],
  " to assign the definition with ",
  StyleBox["int",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "; that is,"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(D[int[x_, a_], y_] ^:= int[D[x, y], a]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Now we check to see if ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " gives us the answer we want."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[int[f[x], {x, 0, 1}], x]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"int", "[", 
      RowBox[{
        RowBox[{
          SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], ",", \({x, 0, 1}\)}], 
      "]"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "As a second example, we define ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["Cos",
              FontWeight->"Bold"], "[", \(n\ \[Pi]\), "]"}], "=", 
          \(\((\(-1\))\)\^n\)}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["Sin",
              FontWeight->"Bold"], "[", \(n\ \[Pi]\), "]"}], "=", "0"}], 
        TraditionalForm]]],
  " for integer ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ":"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[{
    \(Unprotect[Cos, Sin]; \n
    Cos[n_\ \[Pi]] := \((\(-1\))\)\^n /; IntegerQ[n]\), 
    \(Sin[n_\ \[Pi]] := 0 /; IntegerQ[n]\), 
    \(\(Protect[Cos, Sin]; \)\)}], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "If we declare m to be an integer (here ",
  StyleBox["UpValues",
    FontWeight->"Bold"],
  " is used),"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(IntegerQ[m] ^= True; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["then", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({Cos[m\ \[Pi]], Sin[m\ \[Pi]]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({\((\(-1\))\)\^m, 0}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.2.2 Local Rules", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Local rewrite rules (",
  StyleBox["lhs",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\` -> \)]],
  StyleBox["rhs",
    FontSlant->"Italic"],
  "  or  ",
  StyleBox["lhs",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\` :> \)]],
  StyleBox["rhs",
    FontSlant->"Italic"],
  ") are useful for making substitutions without making the definitions \
permanent. These rules are applied to an expression using the operation ",
  Cell[BoxData[
      \(TraditionalForm\` /. \)]],
  " (means ",
  StyleBox["ReplaceAll",
    FontWeight->"Bold"],
  ") or ",
  Cell[BoxData[
      \(TraditionalForm\` //. \)]],
  " (means ",
  StyleBox["ReplaceRepeated",
    FontWeight->"Bold"],
  " in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ")."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[TextData[{
  "1.2.2.1   ",
  Cell[BoxData[
      \(TraditionalForm\` -> \)]],
  " rules"
}], "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "We can use ",
  StyleBox["Solve",
    FontWeight->"Bold"],
  " to obtain the solutions of some algebraic equations. For example,"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq1 = u\^2 - 3\ u + 2 == 0; \nsol1 = Solve[eq1, u]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{u \[Rule] 1}, {u \[Rule] 2}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "We can check the result by substituting ",
  StyleBox["sol1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " into ",
  StyleBox["eq1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " and obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq1 /. sol1\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({True, True}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The output of ",
  StyleBox["Solve",
    FontWeight->"Bold"],
  " is a list of lists of local rules. Thus, ",
  Cell[BoxData[
      \(TraditionalForm\`u -> 1\)]],
  " is a local rule, which is the analog of the global rule ",
  Cell[BoxData[
      \(TraditionalForm\`u = 1\)]],
  ". The rule is applied to an expression by using /. , so the expression ",
  StyleBox["eq1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  StyleBox["/.",
    FontWeight->"Bold"],
  StyleBox["sol1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " means \"use the rewrite rules ",
  Cell[BoxData[
      \(TraditionalForm\`u -> 1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u -> 2\)]],
  " in ",
  StyleBox["eq1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "\". The result of this is ",
  Cell[BoxData[
      \(TraditionalForm\`{0 == 0, 0 == 0}\)]],
  ", which is then evaluated as {",
  StyleBox["True, True",
    FontWeight->"Bold"],
  "}. The usual form of the right-hand side of /. is a list of local rules \
for some of the symbols that appear on the left-hand side."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(u\ v\ w /. {u -> 3, w -> 5}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(15\ v\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
If the right-hand side is a list of lists of local rules, then the result is \
a list of modified expressions, one for each substitution in the list.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(u\ v\ w /. {{u -> 3, w -> 5}, {v -> 2, w -> 3}}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({15\ v, 6\ u}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Local replacement rules also work on expressions which have a ",
  StyleBox["Hold",
    FontWeight->"Bold"],
  " wrapped around them. For example, without a ",
  StyleBox["Hold",
    FontWeight->"Bold"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\_x Cos[x]\)]],
  " immediately evaluates to ",
  Cell[BoxData[
      \(TraditionalForm\`\(-Sin[x]\)\)]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_x Cos[x]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(-Sin[x]\)\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "However, the rewrite rule goes under the ",
  StyleBox["Hold",
    FontWeight->"Bold"],
  " to make the replacement."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(Hold[\[PartialD]\_x Cos[x]] /. Cos -> Sin\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Hold[\[PartialD]\_x Sin[x]]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Local rules with \"",
  Cell[BoxData[
      \(TraditionalForm\` -> \)]],
  "\" share with \"",
  Cell[BoxData[
      \(TraditionalForm\` = \)]],
  "\" rules the property that their right-hand sides are evaluated at the \
time they are defined."
}], "Text",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "1.2.2.2   ",
  Cell[BoxData[
      \(TraditionalForm\` :> \)]],
  " rules"
}], "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The local analog of a \"",
  Cell[BoxData[
      \(TraditionalForm\` := \)]],
  "\" rule is a \"",
  Cell[BoxData[
      \(TraditionalForm\` :> \)]],
  "\" rule; i.e., a local rule that evaluates its right-hand side only when \
it is used. For example,"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(expr1 = Exp[I \((\[Omega]\_2 - \[Omega]\_1)\) T\_0]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Clear[a]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(expr1 /. Exp[a_] -> Exp[Expand[a]]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(E\^\(I\ T\_0\ \((\(-\[Omega]\_1\) + \[Omega]\_2)\)\)\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \({expr1 /. Exp[a_] :> Exp[Expand[a]], expr1 // ExpandAll}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\), 
      E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "where the immediate rule (",
  StyleBox["lhs",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\` -> \)]],
  StyleBox["rhs",
    FontSlant->"Italic"],
  ") fails to do the expansion. The left-hand sides of the local rules \
involve patterns rather than just symbols. The difference is that the \
immediate rule for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["Exp",
            FontWeight->"Bold"], "[", "a_", "]"}], TraditionalForm]]],
  " replaces it by the evaluation of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["Exp",
            FontWeight->"Bold"], "[", 
          RowBox[{
            StyleBox["Expand",
              FontWeight->"Bold"], "[", "a", "]"}], "]"}], 
        TraditionalForm]]],
  " which equals ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["Exp",
            FontWeight->"Bold"], "[", "a", "]"}], TraditionalForm]]],
  ". Hence, when this is used with ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " equal to ",
  Cell[BoxData[
      \(TraditionalForm\`\(I(\[Omega]\_2 - \[Omega]\_1)\) T\_0\)]],
  ", we get the result ",
  Cell[BoxData[
      \(TraditionalForm
      \`E\^\(I\ T\_0\ \((\(-\[Omega]\_1\) + \[Omega]\_2)\)\)\)]],
  ". On the other hand, the delayed rule (",
  StyleBox["lhs",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\` :> \)]],
  StyleBox["rhs",
    FontSlant->"Italic"],
  ") for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["Exp",
            FontWeight->"Bold"], "[", "a_", "]"}], TraditionalForm]]],
  " replaces it by the unevaluated ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["Exp",
            FontWeight->"Bold"], "[", 
          RowBox[{
            StyleBox["Expand",
              FontWeight->"Bold"], "[", "a", "]"}], "]"}], 
        TraditionalForm]]],
  " which, when used with ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " equal to ",
  Cell[BoxData[
      \(TraditionalForm\`\(I(\[Omega]\_2 - \[Omega]\_1)\) T\_0\)]],
  ", gives ",
  Cell[BoxData[
      \(TraditionalForm
      \`E\^\(\(-I\)\ T\_0\ \[Omega]\_1 + I\ T\_0\ \[Omega]\_2\)\)]],
  ". Alternatively, for this simple example, we can use ",
  StyleBox["ExpandAll",
    FontWeight->"Bold"],
  " to obtain the same result."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
We can check how these expressions are represented internally.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[Hold[p /. q -> r]]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    TagBox[
      StyleBox[\(Hold[ReplaceAll[p, Rule[q, r]]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True],
      FullForm]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[Hold[p /. q :> r]]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    TagBox[
      StyleBox[\(Hold[ReplaceAll[p, RuleDelayed[q, r]]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True],
      FullForm]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Thus, /. is the infix form of ",
  StyleBox["ReplaceAll",
    FontWeight->"Bold"],
  ", the arrow ",
  Cell[BoxData[
      \(TraditionalForm\` -> \)]],
  " is the infix form of ",
  StyleBox["Rule",
    FontWeight->"Bold"],
  ", and the arrow ",
  Cell[BoxData[
      \(TraditionalForm\` :> \)]],
  " is the infix form of ",
  StyleBox["RuleDelayed",
    FontWeight->"Bold"],
  ", corresponding to ",
  StyleBox["Set",
    FontWeight->"Bold"],
  " and ",
  StyleBox["SetDelayed",
    FontWeight->"Bold"],
  " for ",
  Cell[BoxData[
      \(TraditionalForm\` = \)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\` := \)]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "1.2.2.3   ",
  Cell[BoxData[
      \(TraditionalForm\` /. \)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\` //. \)]]
}], "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "There is another form of ",
  Cell[BoxData[
      \(TraditionalForm\` /. \)]],
  " given by ",
  Cell[BoxData[
      \(TraditionalForm\` //. \)]],
  " which applies a local rule repeatedly until the expression no longer \
changes. Internally, ",
  Cell[BoxData[
      \(TraditionalForm\` //. \)]],
  " is represented by"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(p //. q -> r // FullForm\) // HoldForm\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    TagBox[
      TagBox[
        StyleBox[\(ReplaceRepeated[p, Rule[q, r]]\),
          ShowSpecialCharacters->False,
          ShowStringCharacters->True],
        FullForm],
      HoldForm]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "An example of the difference between ",
  Cell[BoxData[
      \(TraditionalForm\` /. \)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\` //. \)]],
  " follows. This example uses a list of rules rather than just a single \
rule. When a list of rules is applied to a single expression, then the rule \
for each symbol is tried from the left until a match is found. In the \
following example, the right-hand side of the ",
  Cell[BoxData[
      \(TraditionalForm\` /. \)]],
  " expression consists of a list of two rules for the same symbol, ",
  StyleBox["fac",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  ". This list is searched from the left until a pattern is found that \
matches the left-hand side of the ",
  Cell[BoxData[
      \(TraditionalForm\` /. \)]],
  " expression. In the first case using ",
  Cell[BoxData[
      \(TraditionalForm\` /. \)]],
  ", as soon as a match is found, the evaluation is finished. In the second \
case using ",
  Cell[BoxData[
      \(TraditionalForm\` //. \)]],
  ", the rules are tried repeatedly from the left on the output of the \
previous evaluation until no matches are found."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(fac[5] /. {fac[1] -> 1, fac[i_] -> i\ fac[i - 1]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(5\ fac[4]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(fac[5] //. {fac[1] -> 1, fac[i_] -> i\ fac[i - 1]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(120\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "In the first case, the left-hand side of the rule ",
  Cell[BoxData[
      \(TraditionalForm\`fac[1] -> 1\)]],
  " does not match anything in ",
  Cell[BoxData[
      \(TraditionalForm\`fac[5]\)]],
  ", but ",
  Cell[BoxData[
      \(TraditionalForm\`fac[i_] -> i\ fac[i - 1]\)]],
  " does with ",
  Cell[BoxData[
      \(TraditionalForm\`i_\)]],
  " equal to 5, so the output is ",
  Cell[BoxData[
      \(TraditionalForm\`5\ fac[4]\)]],
  ". In the second case, the left-hand side of the rule ",
  Cell[BoxData[
      \(TraditionalForm\`fac[i_] -> i\ fac[i - 1]\)]],
  " continues to match a part of the existing expression until ",
  Cell[BoxData[
      \(TraditionalForm\`120\ fac[1]\)]],
  " is obtained. Then the left-hand side of the rule ",
  Cell[BoxData[
      \(TraditionalForm\`fac[1] -> 1\)]],
  " matches, leading to ",
  Cell[BoxData[
      \(TraditionalForm\`\(120*1, \)\)]],
  " which simplifies to ",
  Cell[BoxData[
      \(TraditionalForm\`120\)]],
  " where neither rule matches, so the output is ",
  Cell[BoxData[
      \(TraditionalForm\`120\)]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "If such rules are given globally, then the order in which they are given \
does not matter since ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will put the more specific rule, ",
  Cell[BoxData[
      \(TraditionalForm\`fac[1] = 1\)]],
  ", first. However, in a list of local rules, applied with ",
  Cell[BoxData[
      \(TraditionalForm\` //. \)]],
  ", we are completely responsible for the ",
  StyleBox["ordering",
    FontColor->RGBColor[0, 0, 1]],
  ". Thus, the following gives the wrong answer:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(fac[5] //. {fac[i_] -> i\ fac[i - 1], fac[1] -> 1}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(0\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
If several local rules are given for different symbols, then these rules are \
applied simultaneously. For example,\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({u, v, w} /. {u -> v, v -> w, w -> s}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({v, w, s}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
If the substitutions are carried out sequentially, then the results are quite \
different.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\({u, v, w} /. {u -> v}\) /. {v -> w}\) /. {w -> s}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({s, s, s}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
In particular, this means that variables can be interchanged without \
introducing an intermediate temporary variable.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({u, v} /. {u -> v, v -> u}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({v, u}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.2.3 Pattern Matching", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is a language based on pattern matching. Patterns refer to the structure \
of expressions. The symbol ",
  Cell[BoxData[
      \(TraditionalForm\`_\)]],
  " by itself, without any symbol on the left, can be used to describe a \
pattern. (Recall that the ",
  StyleBox["FullForm",
    FontWeight->"Bold"],
  " of _ is ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["Blank",
              FontWeight->"Bold"], "[", "]"}], " "}], TraditionalForm]]],
  "). For instance, the expression ",
  Cell[BoxData[
      \(TraditionalForm\`_^_\)]],
  " matches anything of the form ",
  Cell[BoxData[
      \(TraditionalForm\`x^y\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " are any (dummy) expressions."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Clear[a, x]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(g1[_, _^_] := u; \n{g1[a, a^a], g1[a, b^c]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u, u}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "A pattern of the form ",
  Cell[BoxData[
      \(TraditionalForm\`x_\)]],
  " is matched by any expression, which is then used for evaluating the \
right-hand side."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(g2[x_^y_, z_] := u[x, y, v[z]]; \n{g2[a^a, a], g2[a^b, c]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u[a, a, v[a]], u[a, b, v[c]]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(g3[x_^y_, x_] := u[y, v[x]]; \n{g3[a^a, a], g3[a^b, c], g3[a^b, a]}\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u[a, v[a]], g3[a\^b, c], u[b, v[a]]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "A pattern of the form ",
  Cell[BoxData[
      \(TraditionalForm\`x_h\)]],
  " is matched by any expression whose head is h."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(g4[x_^y_Integer, z_] := u[x, y, v[z]]; 
    \n{g4[a^a, a], g4[a^3, arg2]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({g4[a\^a, a], u[a, 3, v[arg2]]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
If we give a rule for an expression involving two separate arguments with \
underscores, then we are constructing a function of two variables. Such a \
function only works if it is given exactly two arguments.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(g5[x_, y_] := x + y; \n{g5[a], g5[a, b], g5[a, b, c]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({g5[a], a + b, g5[a, b, c]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Besides rule-schemes using a single underscore_, there are rule-schemes \
using double and triple underscores. A double underscore, __, is matched by \
any number of  arguments, excluding zero arguments, separated by commas, \
while a triple underscore, ___, is matched by any number of arguments, \
including zero arguments. The form ",
  Cell[BoxData[
      \(TraditionalForm\`x__\)]],
  " means a sequence of one or more arguments, named x, and x__Head means a \
sequence of one or more arguments, named x, with the head of each argument is \
Head. Similarly, the form x___ means zero or more arguments, named x, and \
x___Head means zero or more arguments, named x, with the head of each \
argument is Head."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(g6[x__] := Length[{x}]; \n{g6[], g6[a], g6[a, b], g6[a, b, c]}\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({g6[], 1, 2, 3}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(g7[x___] := Length[{x}]; \n{g7[], g7[a], g7[a, b], g7[a, b, c]}\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({0, 1, 2, 3}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Default values and double and triple underscores are important techniques, \
which give optional number of arguments to functions; that is, a variable \
number of arguments can be given to such functions. Alternatively, there is \
another rule in which a specific argument can be optional.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(g8[x_^y_, z_] := u[x, y, z]; \n{g8[a^b, c], g8[a, c]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u[a, b, c], g8[a, c]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Because ",
  Cell[BoxData[
      \(TraditionalForm\`a = a^1\)]],
  StyleBox[",",
    FontSlant->"Italic"],
  " one might think that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["g8",
            FontWeight->"Bold",
            FontColor->RGBColor[1, 0, 1]], "[", \(a, c\), "]"}], 
        TraditionalForm]]],
  " should match the pattern ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["g8",
            FontWeight->"Bold",
            FontColor->RGBColor[1, 0, 1]], "[", \(a^1, c\), "]"}], 
        TraditionalForm]]],
  ", which would mean that it should be rewritten as ",
  Cell[BoxData[
      \(TraditionalForm\`u[a, 1, c]\)]],
  ", but of course ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " cannot guess that this is what we intend. However, there is a provision \
to take care of such default values. To assign a default value ",
  StyleBox["v ",
    FontSlant->"Italic"],
  "to a pattern",
  StyleBox[", ",
    FontSlant->"Italic"],
  "one can",
  StyleBox[" ",
    FontSlant->"Italic"],
  "write ",
  Cell[BoxData[
      \(TraditionalForm\`_ : v\)]],
  ". So, the effect we wanted to achieve is given by the form"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(g9[x_^\((y_:  1)\), z_] := u[x, y, z]; \n{g9[a^b, c], g9[a, c]}\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u[a, b, c], u[a, 1, c]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "In this case, the default value 1 for the exponent is the natural and \
obvious choice, and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " knows this. It has standard built-in default values for a number of such \
positions. The notation ",
  Cell[BoxData[
      \(TraditionalForm\`_. \)]],
  " tells ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to use the built-in default value. Note the almost invisible period after \
the underscore. Thus, the effect we wanted at the beginning is given by a \
tiny modification of the original form."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(g10[x_^y_. , z_] := u[x, y, z]; \n{g10[a^b, c], g10[a, c]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u[a, b, c], u[a, 1, c]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "There is still another way that optional arguments occur in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Some functions, such as ",
  StyleBox["Plot",
    FontWeight->"Bold"],
  ", can take named optional arguments such as AspectRatio",
  Cell[BoxData[
      \(TraditionalForm\`\(\( -> 1. \)\ \ \)\)]],
  "By incorporating such functions into our own definitions, we can use these \
named optional arguments too. Consider an example of a plotting function."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(plotwithSin[func_, var_, opts___] := 
      Plot[{Sin[var], func[var]}, {var, 0, 2  Pi}, opts, 
        PlotStyle -> {RGBColor[1, 0, 0], RGBColor[0, 0, 1]}]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(plotwithSin[Cos[2  #]\ &, x]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.309017 0.294302 [
[.17539 .29652 -3 -9 ]
[.17539 .29652 3 0 ]
[.32696 .29652 -3 -9 ]
[.32696 .29652 3 0 ]
[.47854 .29652 -3 -9 ]
[.47854 .29652 3 0 ]
[.63011 .29652 -3 -9 ]
[.63011 .29652 3 0 ]
[.78169 .29652 -3 -9 ]
[.78169 .29652 3 0 ]
[.93327 .29652 -3 -9 ]
[.93327 .29652 3 0 ]
[.01131 .01471 -12 -4.5 ]
[.01131 .01471 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.17539 .30902 m
.17539 .31527 L
s
[(1)] .17539 .29652 0 1 Mshowa
.32696 .30902 m
.32696 .31527 L
s
[(2)] .32696 .29652 0 1 Mshowa
.47854 .30902 m
.47854 .31527 L
s
[(3)] .47854 .29652 0 1 Mshowa
.63011 .30902 m
.63011 .31527 L
s
[(4)] .63011 .29652 0 1 Mshowa
.78169 .30902 m
.78169 .31527 L
s
[(5)] .78169 .29652 0 1 Mshowa
.93327 .30902 m
.93327 .31527 L
s
[(6)] .93327 .29652 0 1 Mshowa
.125 Mabswid
.05412 .30902 m
.05412 .31277 L
s
.08444 .30902 m
.08444 .31277 L
s
.11476 .30902 m
.11476 .31277 L
s
.14507 .30902 m
.14507 .31277 L
s
.2057 .30902 m
.2057 .31277 L
s
.23602 .30902 m
.23602 .31277 L
s
.26633 .30902 m
.26633 .31277 L
s
.29665 .30902 m
.29665 .31277 L
s
.35728 .30902 m
.35728 .31277 L
s
.38759 .30902 m
.38759 .31277 L
s
.41791 .30902 m
.41791 .31277 L
s
.44822 .30902 m
.44822 .31277 L
s
.50885 .30902 m
.50885 .31277 L
s
.53917 .30902 m
.53917 .31277 L
s
.56948 .30902 m
.56948 .31277 L
s
.5998 .30902 m
.5998 .31277 L
s
.66043 .30902 m
.66043 .31277 L
s
.69074 .30902 m
.69074 .31277 L
s
.72106 .30902 m
.72106 .31277 L
s
.75138 .30902 m
.75138 .31277 L
s
.81201 .30902 m
.81201 .31277 L
s
.84232 .30902 m
.84232 .31277 L
s
.87264 .30902 m
.87264 .31277 L
s
.90295 .30902 m
.90295 .31277 L
s
.96358 .30902 m
.96358 .31277 L
s
.9939 .30902 m
.9939 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01471 m
.03006 .01471 L
s
[(-1)] .01131 .01471 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .30902 m
.06244 .38322 L
.10458 .45852 L
.14415 .51889 L
.18221 .56357 L
.20178 .58047 L
.21267 .58793 L
.22272 .59354 L
.23293 .59796 L
.23832 .59976 L
.24402 .60127 L
.24641 .60178 L
.24897 .60225 L
.25119 .60258 L
.25361 .60288 L
.25507 .60302 L
.25643 .60313 L
.25773 .60321 L
.2584 .60324 L
.25912 .60327 L
.25983 .60329 L
.26048 .60331 L
.26176 .60332 L
.26293 .60331 L
.26416 .60329 L
.26538 .60324 L
.26607 .60321 L
.26671 .60317 L
.26912 .60299 L
.27131 .60275 L
.27364 .60244 L
.27847 .60156 L
.2838 .60025 L
.29326 .59705 L
.30213 .59301 L
.32232 .58025 L
.34082 .56432 L
.38045 .51781 L
.41855 .45965 L
.45912 .38744 L
.49816 .31259 L
.53966 .23289 L
.57964 .1614 L
.61811 .10221 L
.63759 .07707 L
.65902 .05386 L
.67938 .03652 L
.69843 .02474 L
.70884 .02018 L
.71396 .01844 L
Mistroke
.71872 .01712 L
.72301 .01617 L
.72758 .01542 L
.7302 .01511 L
.73148 .015 L
.73266 .0149 L
.73371 .01484 L
.73487 .01478 L
.73603 .01474 L
.73725 .01472 L
.73856 .01472 L
.73977 .01473 L
.7404 .01475 L
.7411 .01477 L
.74251 .01484 L
.74375 .01492 L
.74508 .01503 L
.74748 .01528 L
.74985 .0156 L
.75235 .01601 L
.7568 .01695 L
.76198 .01836 L
.7668 .01998 L
.77773 .02472 L
.78828 .0307 L
.79823 .03757 L
.81683 .05353 L
.85534 .09846 L
.89632 .16101 L
.93577 .23146 L
.97371 .3042 L
.97619 .30902 L
Mfstroke
0 0 1 r
.02381 .60332 m
.02499 .60328 L
.02605 .60319 L
.02729 .60301 L
.02846 .60277 L
.03053 .60216 L
.03279 .60126 L
.03527 .59996 L
.0379 .59825 L
.04262 .5943 L
.05205 .58312 L
.06244 .5659 L
.0842 .51473 L
.10458 .45142 L
.14335 .3071 L
.18458 .15507 L
.20517 .0934 L
.21519 .06887 L
.22428 .05023 L
.2338 .03472 L
.24277 .02404 L
.2477 .01987 L
.25224 .01711 L
.25461 .01608 L
.25597 .01562 L
.25722 .01528 L
.25853 .01501 L
.25925 .0149 L
.25994 .01481 L
.26115 .01473 L
.26184 .01472 L
.26248 .01472 L
.26365 .01479 L
.26489 .01494 L
.26595 .01513 L
.26711 .01541 L
.2697 .01627 L
.2721 .01738 L
.27647 .02014 L
.28114 .02415 L
.28669 .03032 L
.29194 .03752 L
.30174 .05445 L
.32176 .10182 L
.34021 .15832 L
.37961 .30382 L
.4175 .4455 L
.43858 .51185 L
.45784 .55895 L
.46737 .57646 L
Mistroke
.4724 .58402 L
.47776 .59073 L
.48291 .59586 L
.48757 .59937 L
.48982 .60067 L
.49225 .60178 L
.49337 .60219 L
.49455 .60256 L
.49565 .60283 L
.49666 .60303 L
.49789 .6032 L
.49854 .60326 L
.49922 .6033 L
.50037 .60332 L
.50164 .60325 L
.50276 .60312 L
.50398 .60291 L
.50512 .60265 L
.50617 .60234 L
.50854 .60145 L
.51113 .60015 L
.51634 .5965 L
.52094 .59215 L
.52585 .58636 L
.53469 .57303 L
.54496 .55304 L
.55607 .52637 L
.57624 .46655 L
.61721 .31615 L
.65666 .16887 L
.6765 .10667 L
.6946 .06186 L
.70461 .04298 L
.71409 .02936 L
.71929 .02373 L
.7241 .01972 L
.72661 .01809 L
.72938 .01666 L
.73077 .01609 L
.73228 .01558 L
.73369 .01521 L
.735 .01496 L
.73627 .0148 L
.73747 .01472 L
.73855 .01472 L
.73973 .01478 L
.741 .01493 L
.74165 .01504 L
.74236 .01518 L
.74362 .0155 L
Mistroke
.74478 .01586 L
.74705 .01677 L
.74949 .01803 L
.7539 .02109 L
.75897 .02581 L
.76451 .03241 L
.77459 .04818 L
.79428 .09194 L
.81525 .15451 L
.85686 .3079 L
.89694 .45656 L
.91533 .51343 L
.92577 .54056 L
.93551 .56194 L
.94506 .57884 L
.94997 .58588 L
.9553 .59221 L
.95822 .59508 L
.96091 .59736 L
.96344 .59916 L
.96623 .60078 L
.96872 .60189 L
.97106 .60264 L
.97235 .60294 L
.97353 .60314 L
.97483 .60327 L
.97548 .60331 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->1,
  ImageSize->{224, 138.313},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003P0000RQP00`40o`000?l0003oh?ooo`00h?oo
o`00h?ooo`00h?ooo`00h?ooo`00h?ooo`00h?ooo`006_ooo`030000oooooooo0<?oool001?oool5
00000_ooo`030000oooooooo0<?oool001Goool00`000?ooooooo`02oooo00<0003oooooool0`ooo
o`003oooo`<00003oooo00<0003oooooool00_ooo`80000/oooo1@00oeSoool2o`001P00o`?o000`
oooo000Eoooo00<0003oooooool00_ooo`030000oooooooo02Woool2003o1Oooo`03003ooooooooo
05Coool01?l00?ooo`00o`00o`Goool01000ooooooooool002ooool001Goool00`000?ooooooo`02
oooo00<0003oooooool0:?ooo`03003ooooooooo00Koool00`00ooooooooo`1Aoooo0_l00003oooo
003ooooo00Ooool00`00ooooooooo`02o`00;Oooo`005?ooo`800004oooo00<0003oooooool0:?oo
o`03003ooooooooo00Ooool00`00ooooooooo`1>oooo0_l000?oool00`00ooooooooo`07oooo00@0
0?ooooooooooool2o`00:oooo`006_ooo`030000oooooooo02Ooool00`00ooooooooo`09oooo00<0
0?ooooooool0Boooo`;o0004oooo00<00?ooooooool02Oooo`03003ooooooooo00;oool2o`00:Ooo
o`006_ooo`030000oooooooo02Koool00`00ooooooooo`0:oooo00<00?ooooooool0B_ooo`03o`00
oooooooo00?oool00`00ooooooooo`0:oooo00<00?ooooooool01?ooo`03o`00oooooooo02Koool0
01[oool200009oooo`03003ooooooooo00_oool00`00ooooooooo`17oooo0_l000Goool00`00oooo
ooooo`0<oooo00<00?ooooooool01?ooo`;o000Voooo000Joooo00<0003oooooool09Oooo`03003o
oooooooo00coool00`00ooooooooo`16oooo00?o003oooooool01Oooo`03003ooooooooo00coool0
0`00ooooooooo`06oooo00?o003oooooool08oooo`006_ooo`030000oooooooo02Goool00`00oooo
ooooo`0=oooo00<00?ooooooool0A?ooo`03o`00oooooooo00Goool00`00ooooooooo`0>oooo00<0
0?ooooooool01_ooo`03o`00oooooooo02;oool001[oool00`000?ooooooo`0Toooo00<00?oooooo
ool03_ooo`03003ooooooooo04?oool00ol00?ooooooo`06oooo00<00?ooooooool03_ooo`03003o
oooooooo00Ooool00ol00?ooooooo`0Qoooo000Joooo00<0003oooooool09?ooo`03003ooooooooo
00ooool00`00ooooooooo`12oooo00?o003oooooool01_ooo`03003ooooooooo00ooool00`00oooo
ooooo`06oooo00?o003oooooool08Oooo`006_ooo`80000Uoooo00<00?ooooooool03oooo`03003o
oooooooo047oool00ol00?ooooooo`06oooo00<00?ooooooool04?ooo`03003ooooooooo00Ooool0
0ol00?ooooooo`0Poooo000Joooo00<0003oooooool08oooo`03003ooooooooo017oool00`00oooo
ooooo`0ooooo00?o003oooooool01oooo`03003ooooooooo017oool00`00ooooooooo`07oooo00?o
003oooooool07oooo`006_ooo`030000oooooooo02?oool00`00ooooooooo`0Aoooo00<00?oooooo
ool0?_ooo`03o`00oooooooo00Ooool00`00ooooooooo`0Boooo00<00?ooooooool02?ooo`03o`00
oooooooo01koool001[oool00`000?ooooooo`0Roooo00<00?ooooooool04oooo`03003ooooooooo
03coool00ol00?ooooooo`08oooo00<00?ooooooool04oooo`03003ooooooooo00Ooool00ol00?oo
ooooo`0Noooo000Joooo00<0003oooooool08_ooo`03003ooooooooo01?oool00`00ooooooooo`0l
oooo00?o003oooooool01oooo`03003ooooooooo01Coool00`00ooooooooo`08oooo00?o003ooooo
ool07Oooo`006_ooo`030000oooooooo02;oool00`00ooooooooo`0Doooo00<00?ooooooool0>_oo
o`03o`00oooooooo00Soool00`00ooooooooo`0Doooo00<00?ooooooool02Oooo`03o`00oooooooo
01coool001[oool200008_ooo`03003ooooooooo01Goool00`00ooooooooo`0ioooo00?o003ooooo
ool02?ooo`03003ooooooooo01Koool00`00ooooooooo`09oooo00?o003oooooool06oooo`006_oo
o`030000oooooooo027oool00`00ooooooooo`0Eoooo00<00?ooooooool0>?ooo`03o`00oooooooo
00Woool00`00ooooooooo`0Foooo00<00?ooooooool02Oooo`03o`00oooooooo01_oool001[oool0
0`000?ooooooo`0Poooo00<00?ooooooool05oooo`03003ooooooooo03Ooool00ol00?ooooooo`09
oooo00<00?ooooooool05_ooo`03003ooooooooo00[oool00ol00?ooooooo`0Joooo000Joooo00<0
003oooooool08?ooo`03003ooooooooo01Ooool00`00ooooooooo`0foooo00?o003oooooool02Ooo
o`03003ooooooooo01Soool00`00ooooooooo`0:oooo00?o003oooooool06Oooo`006_ooo`030000
oooooooo023oool00`00ooooooooo`0Goooo00<00?ooooooool0=Oooo`03o`00oooooooo00[oool0
0`00ooooooooo`0Hoooo00<00?ooooooool02_ooo`03o`00oooooooo01Woool001[oool00`000?oo
ooooo`0Ooooo00<00?ooooooool06Oooo`03003ooooooooo03Coool00ol00?ooooooo`0:oooo00<0
0?ooooooool06?ooo`03003ooooooooo00_oool00ol00?ooooooo`0Hoooo000Joooo0P00023oool0
0`00ooooooooo`0Ioooo00<00?ooooooool0<oooo`03o`00oooooooo00[oool00`00ooooooooo`0I
oooo00<00?ooooooool03?ooo`03o`00oooooooo01Ooool001[oool00`000?ooooooo`0Ooooo00<0
0?ooooooool06Oooo`03003ooooooooo03;oool00ol00?ooooooo`0;oooo00<00?ooooooool06_oo
o`03003ooooooooo00coool00ol00?ooooooo`0Foooo000Joooo00<0003oooooool07_ooo`03003o
oooooooo01_oool00`00ooooooooo`0aoooo00?o003oooooool02oooo`03003ooooooooo01[oool0
0`00ooooooooo`0<oooo00?o003oooooool05_ooo`006_ooo`030000oooooooo01koool00`00oooo
ooooo`0Koooo00<00?ooooooool0<?ooo`03o`00oooooooo00coool00`00ooooooooo`0Joooo00<0
0?ooooooool03Oooo`03o`00oooooooo01Goool000_oool00`000?ooooooo`02oooo00<0003ooooo
ool00_ooo`030000oooooooo00;oool00`000?ooooooo`0Moooo00<00?ooooooool07?ooo`03003o
oooooooo02ooool00ol00?ooooooo`0<oooo00<00?ooooooool07?ooo`03003ooooooooo00goool0
0ol00?ooooooo`0Doooo000:oooo00<0003oool000001oooo`030000oooo000000?oool00`000?oo
ooooo`0Moooo00<00?ooooooool07Oooo`03003ooooooooo02koool00ol00?ooooooo`0<oooo00<0
0?ooooooool07?ooo`03003ooooooooo00goool00ol00?ooooooo`0Doooo0005oooo0`0000;oool0
0`000?ooo`000009oooo00@0003oooooooooool200007_ooo`03003ooooooooo01goool00`00oooo
ooooo`0]oooo00?o003oooooool03Oooo`03003ooooooooo01coool00`00ooooooooo`0>oooo00?o
003oooooool04oooo`002_ooo`030000oooo000000Ooool200001?ooo`030000oooooooo01coool0
0`00ooooooooo`0Noooo00<00?ooooooool0;?ooo`03o`00oooooooo00goool00`00ooooooooo`0N
oooo00<00?ooooooool03_ooo`03o`00oooooooo01;oool000[oool00`000?ooo`000007oooo00<0
003oooooool00oooo`030000oooooooo01coool00`00ooooooooo`0Ooooo00<00?ooooooool0:ooo
o`03o`00oooooooo00goool00`00ooooooooo`0Noooo00<00?ooooooool03_ooo`03o`00oooooooo
01;oool000_oool00`000?ooooooo`06oooo0`0000?oool00`000?ooooooo`0Loooo00<00?oooooo
ool07oooo`03003ooooooooo02[oool00ol00?ooooooo`0>oooo00<00?ooooooool07_ooo`03003o
oooooooo00ooool00ol00?ooooooo`0Aoooo000Joooo00<0003oooooool07?ooo`03003ooooooooo
01ooool00`00ooooooooo`0Zoooo00?o003oooooool03Oooo`03003ooooooooo01ooool00`00oooo
ooooo`0?oooo00?o003oooooool04Oooo`006_ooo`030000oooooooo01_oool00`00ooooooooo`0P
oooo00<00?ooooooool0:Oooo`03o`00oooooooo00koool00`00ooooooooo`0Poooo00<00?oooooo
ool03oooo`03o`00oooooooo013oool001[oool200007?ooo`03003ooooooooo027oool00`00oooo
ooooo`0Xoooo00?o003oooooool03_ooo`03003ooooooooo023oool00`00ooooooooo`0?oooo00?o
003oooooool04?ooo`006_ooo`030000oooooooo01_oool00`00ooooooooo`0Qoooo00<00?oooooo
ool09oooo`03o`00oooooooo00ooool00`00ooooooooo`0Poooo00<00?ooooooool04?ooo`03o`00
oooooooo00ooool001[oool00`000?ooooooo`0Koooo00<00?ooooooool08Oooo`03003ooooooooo
02Ooool00ol00?ooooooo`0>oooo00<00?ooooooool08_ooo`03003ooooooooo013oool00ol00?oo
ooooo`0>oooo000Joooo00<0003oooooool06_ooo`03003ooooooooo02;oool00`00ooooooooo`0V
oooo00?o003oooooool03oooo`03003ooooooooo02;oool00`00ooooooooo`0@oooo00?o003ooooo
ool03_ooo`006_ooo`030000oooooooo01[oool00`00ooooooooo`0Soooo00<00?ooooooool09Ooo
o`03o`00oooooooo00ooool00`00ooooooooo`0Roooo00<00?ooooooool04Oooo`03o`00oooooooo
00goool001[oool00`000?ooooooo`0Joooo00<00?ooooooool08oooo`03003ooooooooo02Coool0
0ol00?ooooooo`0@oooo00<00?ooooooool08_ooo`03003ooooooooo017oool00ol00?ooooooo`0=
oooo000Joooo0P0001_oool00`00ooooooooo`0Soooo00<00?ooooooool09?ooo`03o`00oooooooo
00ooool00`00ooooooooo`0Toooo00<00?ooooooool04Oooo`03o`00oooooooo00coool001[oool0
0`000?ooooooo`0Ioooo00<00?ooooooool09Oooo`03003ooooooooo02;oool00ol00?ooooooo`0@
oooo00<00?ooooooool09?ooo`03003ooooooooo017oool00ol00?ooooooo`0<oooo000Joooo00<0
003oooooool06Oooo`03003ooooooooo02Goool00`00ooooooooo`0Roooo00?o003oooooool04?oo
o`03003ooooooooo02Coool00`00ooooooooo`0Boooo00?o003oooooool02oooo`006_ooo`030000
oooooooo01Woool00`00ooooooooo`0Uoooo00<00?ooooooool08Oooo`03o`00oooooooo013oool0
0`00ooooooooo`0Voooo00<00?ooooooool04Oooo`03o`00oooooooo00_oool001[oool00`000?oo
ooooo`0Hoooo00<00?ooooooool09_ooo`03003ooooooooo023oool00ol00?ooooooo`0Aoooo00<0
0?ooooooool09_ooo`03003ooooooooo01;oool00ol00?ooooooo`0:oooo000Joooo00<0003ooooo
ool06?ooo`03003ooooooooo02Ooool00`00ooooooooo`0Ooooo00?o003oooooool04Oooo`03003o
oooooooo02Koool00`00ooooooooo`0Boooo00?o003oooooool02_ooo`006_ooo`80000Ioooo00<0
0?ooooooool09oooo`03003ooooooooo01koool00ol00?ooooooo`0Boooo00<00?ooooooool09ooo
o`03003ooooooooo01;oool00ol00?ooooooo`09oooo000Joooo00<0003oooooool06?ooo`03003o
0000000000<0000Koooo0`0000Koool00`00ooooooooo`0Boooo0P0000[oool00ol00?ooooooo`0A
oooo00<00?l0000000006oooo`030000oooooooo00[oool00`00ooooooooo`0>oooo0P0000;oool0
0ol00?ooooooo`09oooo000Joooo00<0003oooooool05oooo`05003ooooooooooooo000001goool0
0`000?ooooooo`07oooo00<00?ooooooool04oooo`030000oooooooo00Koool00ol00?ooooooo`0B
oooo00<00?l0003oool06_ooo`030000oooo000000_oool00`00ooooooooo`0>oooo00<0003oool0
00000_ooo`03o`00oooooooo00Soool001[oool00`000?ooooooo`0Goooo00D00?ooooooooooool0
00007_ooo`030000oooooooo00Koool00`00ooooooooo`0Boooo00<0003oooooool01oooo`03o`00
oooooooo017oool010000000o`00000001coool00`000?ooooooo`09oooo00<00?ooooooool03_oo
o`030000oooo000000;oool00ol00?ooooooo`08oooo000Joooo00<0003oooooool05oooo`05003o
oooooooooooo000001koool00`000?ooooooo`06oooo00<00?ooooooool04oooo`030000oooooooo
00Goool00ol00?ooooooo`0Boooo00<00?ooool000006oooo`80000=oooo00<00?ooooooool03Ooo
o`800004oooo00?o003oooooool01oooo`006_ooo`030000oooooooo01Ooool01@00oooooooooooo
o`00000Moooo00<0003oool000001oooo`03003ooooooooo017oool00`000?ooo`000006oooo00?o
003oooooool04oooo`03003o0000000001_oool00`000?ooooooo`0<oooo00<00?ooooooool03Ooo
o`030000oooooooo00?oool00ol00?ooooooo`07oooo000Joooo0P0001Ooool01000oooooooooooo
o`80000Noooo00<0003oooooool01oooo`03003ooooooooo017oool00`000?ooooooo`05oooo00?o
003oooooool04oooo`03003ooooo000001_oool300003?ooo`03003ooooooooo00koool200001?oo
o`03o`00oooooooo00Koool001[oool00`000?ooooooo`0Foooo00<00?ooooooool0:oooo`03003o
oooooooo01Soool00ol00?ooooooo`0Doooo00<00?ooooooool0:oooo`03003ooooooooo01?oool0
0ol00?ooooooo`06oooo000Joooo00<0003oooooool05_ooo`03003ooooooooo02_oool00`00oooo
ooooo`0Hoooo00?o003oooooool04oooo`03003ooooooooo02coool00`00ooooooooo`0Doooo00?o
003oooooool01Oooo`006_ooo`030000oooooooo01Koool00`00ooooooooo`0[oooo00<00?oooooo
ool05oooo`03o`00oooooooo01Coool00`00ooooooooo`0/oooo00<00?ooooooool05?ooo`03o`00
oooooooo00Goool001[oool00`000?ooooooo`0Eoooo00<00?ooooooool0;Oooo`03003ooooooooo
01Koool00ol00?ooooooo`0Doooo00<00?ooooooool0;?ooo`03003ooooooooo01Goool00ol00?oo
ooooo`04oooo000Joooo00<0003oooooool05Oooo`03003ooooooooo02goool00`00ooooooooo`0E
oooo00?o003oooooool05Oooo`03003ooooooooo02goool00`00ooooooooo`0Doooo00?o003ooooo
ool01?ooo`005Oooo`D000000ol000000000000E000000<00?l000000000;@000003003o00000000
01D000000ol000000000000D000000<00?l000000000;P000003003o0000000001D000000ol00000
000000030000000Joooo00<0003o003oool00oooo`030000oooooooo00?oool00`000?ooooooo`03
oooo00<0003oooooool00_ooo`03003o0000oooo00Goool00`000?ooooooo`03oooo00<0003ooooo
ool00oooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000
oooooooo00?oool00`000?ooooooo`02oooo00<00?l0003oool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00@0003ooooooooo0002oooo00<0003oooooool00oooo`030000oooooooo
00?oool00`000?ooooooo`03oooo00@0003oooooool00?l2oooo00<0003oooooool00oooo`030000
oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo00<0003oooooool00oooo`040000oooooooo003o0_ooo`030000oooooooo
00?oool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00?oool100000Ooo
o`7oool001[oool00`000?l00?ooo`0Doooo00<00?ooooooool0;oooo`03003ooooooooo01?oool0
0ol00?ooooooo`0Eoooo00<00?ooooooool0;oooo`03003ooooooooo01[oool001[oool00`000?oo
ool0000Doooo00<00?ooooooool0;oooo`03003ooooooooo01;oool00ol00?ooooooo`0Eoooo00<0
0?ooooooool0<?ooo`03003ooooooooo01[oool001[oool00`000?ooool0000Doooo00<00?oooooo
ool0;oooo`03003ooooooooo01;oool00ol00?ooooooo`0Eoooo00<00?ooooooool0<?ooo`03003o
oooooooo01[oool001[oool010000?ooooooool001;oool00`00ooooooooo`0`oooo00<00?oooooo
ool04Oooo`03o`00oooooooo01Koool00`00ooooooooo`0`oooo00<00?ooooooool06_ooo`006_oo
o`8000000oooool00?ooo`0Aoooo00<00?ooooooool0<Oooo`03003ooooooooo013oool00ol00?oo
ooooo`0Foooo00<00?ooooooool0<Oooo`03003ooooooooo01Woool001[oool01@000?oooooooooo
ool0000Aoooo00<00?ooooooool0<Oooo`03003ooooooooo00ooool00ol00?ooooooo`0Foooo00<0
0?ooooooool0<_ooo`03003ooooooooo01Woool001[oool01@000?ooooooooooool0000Aoooo00<0
0?ooooooool0<Oooo`03003ooooooooo00ooool00ol00?ooooooo`0Foooo00<00?ooooooool0<_oo
o`03003ooooooooo01Woool001[oool00`000?ooooooo`02oooo00?o003oooooool03Oooo`03003o
oooooooo03;oool00`00ooooooooo`0>oooo00?o003oooooool05oooo`03003ooooooooo03;oool0
0`00ooooooooo`0Ioooo000Joooo00<0003oooooool00_ooo`03o`00oooooooo00goool00`00oooo
ooooo`0coooo00<00?ooooooool03Oooo`03o`00oooooooo01Ooool00`00ooooooooo`0coooo00<0
0?ooooooool06?ooo`006_ooo`030000oooooooo00?oool00ol00?ooooooo`0<oooo00<00?oooooo
ool0<oooo`03003ooooooooo00coool00ol00?ooooooo`0Goooo00<00?ooooooool0=?ooo`03003o
oooooooo01Soool001[oool200001?ooo`03o`00oooooooo00coool00`00ooooooooo`0coooo00<0
0?ooooooool03?ooo`03o`00oooooooo01Ooool00`00ooooooooo`0doooo00<00?ooooooool06?oo
o`006_ooo`030000oooooooo00Coool00ol00?ooooooo`0:oooo00<00?ooooooool0=?ooo`03003o
oooooooo00_oool00ol00?ooooooo`0Hoooo00<00?ooooooool0=?ooo`03003ooooooooo01Soool0
01[oool00`000?ooooooo`04oooo00?o003oooooool02_ooo`03003ooooooooo03Goool00`00oooo
ooooo`0:oooo00?o003oooooool06?ooo`03003ooooooooo03Goool00`00ooooooooo`0Goooo000J
oooo00<0003oooooool01Oooo`03o`00oooooooo00Woool00`00ooooooooo`0eoooo00<00?oooooo
ool02Oooo`03o`00oooooooo01Soool00`00ooooooooo`0foooo00<00?ooooooool05oooo`006_oo
o`030000oooooooo00Koool00ol00?ooooooo`07oooo00<00?ooooooool0=_ooo`03003ooooooooo
00Woool00ol00?ooooooo`0Hoooo00<00?ooooooool0=_ooo`03003ooooooooo01Ooool001[oool0
0`000?ooooooo`06oooo00?o003oooooool01oooo`03003ooooooooo03Koool00`00ooooooooo`08
oooo00?o003oooooool06Oooo`03003ooooooooo03Ooool00`00ooooooooo`0Foooo000Joooo0P00
00Soool00ol00?ooooooo`06oooo00<00?ooooooool0=oooo`03003ooooooooo00Ooool00ol00?oo
ooooo`0Ioooo00<00?ooooooool0=oooo`03003ooooooooo01Koool001[oool00`000?ooooooo`07
oooo00?o003oooooool01_ooo`03003ooooooooo03Ooool00`00ooooooooo`06oooo00?o003ooooo
ool06Oooo`03003ooooooooo03Soool00`00ooooooooo`0Foooo000Joooo00<0003oooooool02?oo
o`03o`00oooooooo00Coool00`00ooooooooo`0hoooo00<00?ooooooool01Oooo`03o`00oooooooo
01[oool00`00ooooooooo`0hoooo00<00?ooooooool05_ooo`006_ooo`030000oooooooo00Soool0
0ol00?ooooooo`04oooo00<00?ooooooool0>?ooo`03003ooooooooo00Goool00ol00?ooooooo`0J
oooo00<00?ooooooool0>Oooo`03003ooooooooo01Goool001[oool00`000?ooooooo`09oooo00?o
003oooooool00oooo`03003ooooooooo03Woool00`00ooooooooo`03oooo00?o003oooooool06ooo
o`03003ooooooooo03Woool00`00ooooooooo`0Eoooo000Joooo00<0003oooooool02Oooo`03o`00
oooooooo00?oool00`00ooooooooo`0ioooo00<00?ooooooool00_ooo`03o`00oooooooo01_oool0
0`00ooooooooo`0joooo00<00?ooooooool05Oooo`006_ooo`80000;oooo00Go003oooooooooool0
0?l0??ooo`03003ooooooooo00;oool00ol00?ooooooo`0Koooo00<00?ooooooool0>_ooo`03003o
oooooooo01Goool001[oool00`000?ooooooo`0:oooo00Go003oooooooooool00?l0??ooo`05003o
ooooooooooooo`0001koool00`00ooooooooo`0koooo00<00?ooooooool05?ooo`006_ooo`030000
oooooooo00_oool01?l00?ooooooo`00ocgoool01000ooooooooool001koool00`00ooooooooo`0k
oooo00<00?ooooooool05?ooo`002oooo`030000oooooooo00;oool00`000?ooooooo`02oooo00<0
003oooooool00_ooo`030000oooooooo00_oool01?l00?ooooooo`00ocgoool00`00ooooool0000N
oooo00<00?ooooooool0??ooo`03003ooooooooo01Coool000[oool00`000?ooo`000007oooo00<0
003oool000000oooo`030000oooooooo00coool00ol00000ooooo`0moooo00<00?oo003oool07_oo
o`03003ooooooooo03coool00`00ooooooooo`0Doooo000:oooo00<0003oool000002Oooo`040000
oooooooooooo0P0000goool00ol00000ooooo`0noooo00<00?ooooooool07Oooo`03003ooooooooo
03goool00`00ooooooooo`0Coooo000:oooo00<0003oool000001oooo`800004oooo00<0003ooooo
ool03Oooo`03003ooooooooo03coool00ol00000ooooo`0Noooo00<00?ooooooool0?Oooo`03003o
oooooooo01?oool000[oool00`000?ooo`000007oooo00<0003oooooool00oooo`030000oooooooo
00coool00`00ooooool0000loooo00?o003oool00?l07_ooo`03003ooooooooo03koool00`00oooo
ooooo`0Coooo000;oooo00<0003oooooool01_ooo`<00003oooo00<0003oooooool03?ooo`03003o
ooooo`0003coool01?l00?ooooooo`00oagoool00`00ooooooooo`0ooooo00<00?ooooooool04_oo
o`006_ooo`030000oooooooo00coool01000ooooooooool003[oool01Ol00?ooooooooooo`00o`0M
oooo00<00?ooooooool0?oooo`03003ooooooooo01;oool001[oool00`000?ooooooo`0;oooo00<0
0?ooooooool00_ooo`03o`00oooooooo03Ooool01Ol00?ooooooooooo`00o`0Loooo00<00?oooooo
ool0@?ooo`03003ooooooooo01;oool001[oool200003?ooo`03003ooooooooo00;oool00ol00?oo
ooooo`0foooo00?o003oooooool00oooo`03003ooooooooo01Woool00`00ooooooooo`10oooo00<0
0?ooooooool04_ooo`006_ooo`030000oooooooo00_oool00`00ooooooooo`03oooo00?o003ooooo
ool0=?ooo`03o`00oooooooo00Coool00`00ooooooooo`0Ioooo00<00?ooooooool0@Oooo`03003o
oooooooo017oool001[oool00`000?ooooooo`0:oooo00<00?ooooooool01Oooo`03o`00oooooooo
03?oool00ol00?ooooooo`05oooo00<00?ooooooool05oooo`03003ooooooooo04;oool00`00oooo
ooooo`0Aoooo000Joooo00<0003oooooool02_ooo`03003ooooooooo00Goool00ol00?ooooooo`0b
oooo00?o003oooooool01_ooo`03003ooooooooo01Ooool00`00ooooooooo`12oooo00<00?oooooo
ool04Oooo`006_ooo`030000oooooooo00[oool00`00ooooooooo`06oooo00?o003oooooool0<Ooo
o`03o`00oooooooo00Koool00`00ooooooooo`0Goooo00<00?ooooooool0@_ooo`03003ooooooooo
017oool001[oool00`000?ooooooo`09oooo00<00?ooooooool02?ooo`03o`00oooooooo02ooool0
0ol00?ooooooo`08oooo00<00?ooooooool05Oooo`03003ooooooooo04Coool00`00ooooooooo`0@
oooo000Joooo0P0000[oool00`00ooooooooo`08oooo00?o003oooooool0;oooo`03o`00oooooooo
00Soool00`00ooooooooo`0Eoooo00<00?ooooooool0A?ooo`03003ooooooooo013oool001[oool0
0`000?ooooooo`09oooo00<00?ooooooool02Oooo`03o`00oooooooo02goool00ol00?ooooooo`09
oooo00<00?ooooooool05Oooo`03003ooooooooo04Goool00`00ooooooooo`0?oooo000Joooo00<0
003oooooool02?ooo`03003ooooooooo00_oool00ol00?ooooooo`0[oooo00?o003oooooool02ooo
o`03003ooooooooo01?oool00`00ooooooooo`16oooo00<00?ooooooool03oooo`006_ooo`030000
oooooooo00Soool00`00ooooooooo`0<oooo00?o003oooooool0:Oooo`03o`00oooooooo00coool0
0`00ooooooooo`0Coooo00<00?ooooooool0Aoooo`03003ooooooooo00koool001[oool00`000?oo
ooooo`08oooo00<00?ooooooool03Oooo`03o`00oooooooo02Ooool00ol00?ooooooo`0=oooo00<0
0?ooooooool04oooo`03003ooooooooo04Ooool00`00ooooooooo`0>oooo000Joooo00<0003ooooo
ool01oooo`03003ooooooooo00ooool00ol00?ooooooo`0Uoooo00?o003oooooool03oooo`03003o
oooooooo017oool00`00ooooooooo`19oooo00<00?ooooooool03Oooo`006_ooo`800008oooo00<0
0?ooooooool03oooo`03o`00oooooooo02Goool00ol00?ooooooo`0?oooo00<00?ooooooool04Ooo
o`03003ooooooooo04Woool00`00ooooooooo`0=oooo000Joooo00<0003oooooool01_ooo`03003o
oooooooo017oool00ol00?ooooooo`0Soooo00?o003oooooool04?ooo`03003ooooooooo013oool0
0`00ooooooooo`1;oooo00<00?ooooooool03?ooo`006_ooo`030000oooooooo00Koool00`00oooo
ooooo`0Boooo00?o003oooooool08Oooo`03o`00oooooooo01;oool00`00ooooooooo`0?oooo00<0
0?ooooooool0Boooo`03003ooooooooo00coool001[oool00`000?ooooooo`06oooo00<00?oooooo
ool04oooo`03o`00oooooooo01ooool00ol00?ooooooo`0Coooo00<00?ooooooool03_ooo`03003o
oooooooo04goool00`00ooooooooo`0;oooo000Joooo00<0003oooooool01Oooo`03003ooooooooo
01Goool00ol00?ooooooo`0Moooo00?o003oooooool05?ooo`03003ooooooooo00koool00`00oooo
ooooo`1=oooo00<00?ooooooool02oooo`006_ooo`030000oooooooo00Goool00`00ooooooooo`0F
oooo00?o003oooooool06oooo`03o`00oooooooo01Koool00`00ooooooooo`0<oooo00<00?oooooo
ool0C_ooo`03003ooooooooo00_oool001[oool200001Oooo`03003ooooooooo01Soool2o`006Ooo
o`;o000Ioooo00<00?ooooooool03?ooo`03003ooooooooo04ooool00`00ooooooooo`0:oooo000J
oooo00<0003oooooool01?ooo`03003ooooooooo01[oool00ol00?ooooooo`0Eoooo00?o003ooooo
ool06_ooo`03003ooooooooo00[oool00`00ooooooooo`1@oooo00<00?ooooooool02_ooo`006_oo
o`030000oooooooo00?oool00`00ooooooooo`0Loooo00?o003oooooool04oooo`03o`00oooooooo
01coool00`00ooooooooo`09oooo00<00?ooooooool0D?ooo`03003ooooooooo00[oool001[oool0
0`000?ooooooo`02oooo00<00?ooooooool07_ooo`03o`00oooooooo013oool2o`007oooo`03003o
oooooooo00Soool00`00ooooooooo`1Boooo00<00?ooooooool02Oooo`004oooo`D00002oooo00D0
003oooooooooool00?l08_ooo`;o000?oooo00?o003oooooool08?ooo`03003ooooooooo00Koool0
0`00ooooooooo`1Doooo0P00o`Woool001Goool00`000?ooooooo`02oooo00@0003oool00?l00?lU
oooo0ol000Soool4o`009?ooo`800?l4oooo0P00oeWoool00`00ooooooooo`06oooo000Eoooo00<0
003oooooool00_ooo`<00?lYoooo2?l002[oool5003oFoooo`<00?l5oooo000Eoooo00<0003ooooo
ool00_ooo`030000oooooooo0<?oool001Goool00`000?ooooooo`02oooo00<0003oooooool0`ooo
o`005?ooo`800004oooo00<0003oooooool0`oooo`00h?ooo`00h?ooo`00h?ooo`00h?ooo`00h?oo
o`00h?ooo`00\
\>"],
  ImageRangeCache->{{{0, 223}, {137.313, 0}} -> {-0.869166, -1.15905, 
  0.0327779, 0.0168818}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(plotwithSin[Cos[2  #]\ &, x, AspectRatio -> 1]; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.5 0.476191 [
[.17539 .4875 -3 -9 ]
[.17539 .4875 3 0 ]
[.32696 .4875 -3 -9 ]
[.32696 .4875 3 0 ]
[.47854 .4875 -3 -9 ]
[.47854 .4875 3 0 ]
[.63011 .4875 -3 -9 ]
[.63011 .4875 3 0 ]
[.78169 .4875 -3 -9 ]
[.78169 .4875 3 0 ]
[.93327 .4875 -3 -9 ]
[.93327 .4875 3 0 ]
[.01131 .02381 -12 -4.5 ]
[.01131 .02381 0 4.5 ]
[.01131 .2619 -24 -4.5 ]
[.01131 .2619 0 4.5 ]
[.01131 .7381 -18 -4.5 ]
[.01131 .7381 0 4.5 ]
[.01131 .97619 -6 -4.5 ]
[.01131 .97619 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.17539 .5 m
.17539 .50625 L
s
[(1)] .17539 .4875 0 1 Mshowa
.32696 .5 m
.32696 .50625 L
s
[(2)] .32696 .4875 0 1 Mshowa
.47854 .5 m
.47854 .50625 L
s
[(3)] .47854 .4875 0 1 Mshowa
.63011 .5 m
.63011 .50625 L
s
[(4)] .63011 .4875 0 1 Mshowa
.78169 .5 m
.78169 .50625 L
s
[(5)] .78169 .4875 0 1 Mshowa
.93327 .5 m
.93327 .50625 L
s
[(6)] .93327 .4875 0 1 Mshowa
.125 Mabswid
.05412 .5 m
.05412 .50375 L
s
.08444 .5 m
.08444 .50375 L
s
.11476 .5 m
.11476 .50375 L
s
.14507 .5 m
.14507 .50375 L
s
.2057 .5 m
.2057 .50375 L
s
.23602 .5 m
.23602 .50375 L
s
.26633 .5 m
.26633 .50375 L
s
.29665 .5 m
.29665 .50375 L
s
.35728 .5 m
.35728 .50375 L
s
.38759 .5 m
.38759 .50375 L
s
.41791 .5 m
.41791 .50375 L
s
.44822 .5 m
.44822 .50375 L
s
.50885 .5 m
.50885 .50375 L
s
.53917 .5 m
.53917 .50375 L
s
.56948 .5 m
.56948 .50375 L
s
.5998 .5 m
.5998 .50375 L
s
.66043 .5 m
.66043 .50375 L
s
.69074 .5 m
.69074 .50375 L
s
.72106 .5 m
.72106 .50375 L
s
.75138 .5 m
.75138 .50375 L
s
.81201 .5 m
.81201 .50375 L
s
.84232 .5 m
.84232 .50375 L
s
.87264 .5 m
.87264 .50375 L
s
.90295 .5 m
.90295 .50375 L
s
.96358 .5 m
.96358 .50375 L
s
.9939 .5 m
.9939 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.02381 .02381 m
.03006 .02381 L
s
[(-1)] .01131 .02381 1 0 Mshowa
.02381 .2619 m
.03006 .2619 L
s
[(-0.5)] .01131 .2619 1 0 Mshowa
.02381 .7381 m
.03006 .7381 L
s
[(0.5)] .01131 .7381 1 0 Mshowa
.02381 .97619 m
.03006 .97619 L
s
[(1)] .01131 .97619 1 0 Mshowa
.125 Mabswid
.02381 .07143 m
.02756 .07143 L
s
.02381 .11905 m
.02756 .11905 L
s
.02381 .16667 m
.02756 .16667 L
s
.02381 .21429 m
.02756 .21429 L
s
.02381 .30952 m
.02756 .30952 L
s
.02381 .35714 m
.02756 .35714 L
s
.02381 .40476 m
.02756 .40476 L
s
.02381 .45238 m
.02756 .45238 L
s
.02381 .54762 m
.02756 .54762 L
s
.02381 .59524 m
.02756 .59524 L
s
.02381 .64286 m
.02756 .64286 L
s
.02381 .69048 m
.02756 .69048 L
s
.02381 .78571 m
.02756 .78571 L
s
.02381 .83333 m
.02756 .83333 L
s
.02381 .88095 m
.02756 .88095 L
s
.02381 .92857 m
.02756 .92857 L
s
.25 Mabswid
.02381 0 m
.02381 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .5 m
.06244 .62007 L
.10458 .74191 L
.14415 .83958 L
.18221 .91187 L
.20178 .93922 L
.21267 .95129 L
.22272 .96036 L
.23293 .96752 L
.23832 .97044 L
.24402 .97288 L
.24641 .9737 L
.24897 .97446 L
.25119 .975 L
.25361 .97548 L
.25507 .97571 L
.25643 .97588 L
.25773 .97601 L
.2584 .97606 L
.25912 .97611 L
.25983 .97615 L
.26048 .97617 L
.26176 .97619 L
.26293 .97618 L
.26416 .97614 L
.26538 .97607 L
.26607 .97601 L
.26671 .97595 L
.26912 .97565 L
.27131 .97527 L
.27364 .97476 L
.27847 .97335 L
.2838 .97123 L
.29326 .96604 L
.30213 .95952 L
.32232 .93887 L
.34082 .9131 L
.38045 .83784 L
.41855 .74373 L
.45912 .62689 L
.49816 .50578 L
.53966 .37683 L
.57964 .26116 L
.61811 .16538 L
.63759 .12471 L
.65902 .08714 L
.67938 .05909 L
.69843 .04002 L
.70884 .03265 L
.71396 .02983 L
Mistroke
.71872 .0277 L
.72301 .02617 L
.72758 .02495 L
.7302 .02446 L
.73148 .02426 L
.73266 .02412 L
.73371 .02401 L
.73487 .02392 L
.73603 .02385 L
.73725 .02382 L
.73856 .02381 L
.73977 .02384 L
.7404 .02386 L
.7411 .0239 L
.74251 .02401 L
.74375 .02414 L
.74508 .02431 L
.74748 .02472 L
.74985 .02524 L
.75235 .02591 L
.7568 .02743 L
.76198 .02971 L
.7668 .03232 L
.77773 .04 L
.78828 .04967 L
.79823 .06079 L
.81683 .08661 L
.85534 .15931 L
.89632 .26052 L
.93577 .37452 L
.97371 .49221 L
.97619 .5 L
Mfstroke
0 0 1 r
.02381 .97619 m
.02499 .97613 L
.02605 .97598 L
.02729 .97569 L
.02846 .9753 L
.03053 .97432 L
.03279 .97285 L
.03527 .97076 L
.0379 .96799 L
.04262 .9616 L
.05205 .94351 L
.06244 .91564 L
.0842 .83285 L
.10458 .73041 L
.14335 .49689 L
.18458 .25091 L
.20517 .15113 L
.21519 .11143 L
.22428 .08128 L
.2338 .05617 L
.24277 .03891 L
.2477 .03215 L
.25224 .02768 L
.25461 .02601 L
.25597 .02527 L
.25722 .02472 L
.25853 .02428 L
.25925 .0241 L
.25994 .02397 L
.26115 .02383 L
.26184 .02381 L
.26248 .02382 L
.26365 .02394 L
.26489 .02418 L
.26595 .02449 L
.26711 .02493 L
.2697 .02632 L
.2721 .02812 L
.27647 .03258 L
.28114 .03907 L
.28669 .04906 L
.29194 .06071 L
.30174 .0881 L
.32176 .16475 L
.34021 .25616 L
.37961 .49159 L
.4175 .72084 L
.43858 .82819 L
.45784 .90439 L
.46737 .93273 L
Mistroke
.4724 .94496 L
.47776 .95583 L
.48291 .96413 L
.48757 .9698 L
.48982 .9719 L
.49225 .97371 L
.49337 .97437 L
.49455 .97496 L
.49565 .97541 L
.49666 .97573 L
.49789 .97601 L
.49854 .9761 L
.49922 .97617 L
.50037 .97618 L
.50164 .97608 L
.50276 .97587 L
.50398 .97554 L
.50512 .9751 L
.50617 .97461 L
.50854 .97317 L
.51113 .97107 L
.51634 .96516 L
.52094 .95812 L
.52585 .94875 L
.53469 .92718 L
.54496 .89484 L
.55607 .85169 L
.57624 .7549 L
.61721 .51155 L
.65666 .27323 L
.6765 .1726 L
.6946 .10009 L
.70461 .06955 L
.71409 .0475 L
.71929 .0384 L
.7241 .03191 L
.72661 .02927 L
.72938 .02695 L
.73077 .02603 L
.73228 .02521 L
.73369 .02461 L
.735 .02421 L
.73627 .02395 L
.73747 .02383 L
.73855 .02382 L
.73973 .02392 L
.741 .02416 L
.74165 .02433 L
.74236 .02456 L
.74362 .02508 L
Mistroke
.74478 .02566 L
.74705 .02713 L
.74949 .02918 L
.7539 .03412 L
.75897 .04176 L
.76451 .05243 L
.77459 .07795 L
.79428 .14876 L
.81525 .25 L
.85686 .49819 L
.89694 .73873 L
.91533 .83075 L
.92577 .87465 L
.93551 .90923 L
.94506 .93659 L
.94997 .94797 L
.9553 .95821 L
.95822 .96286 L
.96091 .96655 L
.96344 .96947 L
.96623 .97208 L
.96872 .97388 L
.97106 .9751 L
.97235 .97558 L
.97353 .9759 L
.97483 .97611 L
.97548 .97617 L
.97619 .97619 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  TextAlignment->Left,
  TextJustification->1,
  ImageSize->{224, 224},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003P0000h1P00`40o`000?l0003oh?ooo`00h?oo
o`00h?ooo`00h?ooo`00h?ooo`00h?ooo`00h?ooo`00h?ooo`00h?ooo`00h?ooo`00h?ooo`006_oo
o`030000oooooooo0<?oool001[oool00`000?ooooooo`33oooo000Joooo00<0003oooooool0`ooo
o`004oooo`D00002oooo00<0003oooooool0`oooo`005Oooo`030000oooooooo00;oool00`000?oo
ooooo`33oooo000?oooo0`0000?oool00`000?ooooooo`02oooo0P0002goool3003oG?ooo`05o`00
003o003o003oo`0003?oool001Goool00`000?ooooooo`02oooo00<0003oooooool0:oooo`05003o
oooooooooooo003o05Soool2o`000P00o`;oool2003o0ol0033oool001Goool00`000?ooooooo`02
oooo00<0003oooooool0:_ooo`03003ooooooooo00?oool00`00ooooooooo`1Doooo00Co003ooooo
ool00?l5oooo00@00?oooooooooo000_oooo000Doooo0P0000Coool00`000?ooooooo`0Yoooo00<0
0?ooooooool01Oooo`03003ooooooooo057oool2o`000_ooo`03003ooooooooo00Coool01000oooo
ooooooooo`;o000]oooo000Joooo00<0003oooooool0:?ooo`03003ooooooooo00Koool00`00oooo
ooooo`1@oooo00Go003oooooooooool00?l02?ooo`03003ooooooooo00;oool00ol00?ooooooo`0Z
oooo000Joooo00<0003oooooool0:?ooo`03003ooooooooo00Ooool00`00ooooooooo`1>oooo00?o
003oooooool00_ooo`03003ooooooooo00Koool00`00ooooooooo`03oooo00?o003oooooool0:Ooo
o`006_ooo`030000oooooooo02Ooool00`00ooooooooo`08oooo00<00?ooooooool0COooo`03o`00
oooooooo00;oool00`00ooooooooo`08oooo00<00?ooooooool00oooo`03o`00oooooooo02Soool0
01[oool00`000?ooooooo`0Woooo00<00?ooooooool02Oooo`03003ooooooooo04_oool00ol00?oo
ooooo`03oooo00<00?ooooooool02?ooo`03003ooooooooo00?oool00ol00?ooooooo`0Xoooo000J
oooo00<0003oooooool09oooo`03003ooooooooo00Woool00`00ooooooooo`1:oooo00?o003ooooo
ool00oooo`03003ooooooooo00[oool00`00ooooooooo`03oooo00?o003oooooool09oooo`006_oo
o`030000oooooooo02Koool00`00ooooooooo`0:oooo00<00?ooooooool0B_ooo`03o`00oooooooo
00?oool00`00ooooooooo`0:oooo00<00?ooooooool01?ooo`03o`00oooooooo02Koool001[oool2
00009oooo`03003ooooooooo00_oool00`00ooooooooo`18oooo00?o003oooooool01?ooo`03003o
oooooooo00_oool00`00ooooooooo`04oooo00?o003oooooool09Oooo`006_ooo`030000oooooooo
02Goool00`00ooooooooo`0<oooo00<00?ooooooool0Aoooo`03o`00oooooooo00Coool00`00oooo
ooooo`0<oooo00<00?ooooooool01?ooo`03o`00oooooooo02Goool001[oool00`000?ooooooo`0U
oooo00<00?ooooooool03Oooo`03003ooooooooo04Koool00ol00?ooooooo`04oooo00<00?oooooo
ool03?ooo`03003ooooooooo00Goool00ol00?ooooooo`0Toooo000Joooo00<0003oooooool09Ooo
o`03003ooooooooo00goool00`00ooooooooo`15oooo00?o003oooooool01Oooo`03003ooooooooo
00goool00`00ooooooooo`05oooo00?o003oooooool08oooo`006_ooo`030000oooooooo02Goool0
0`00ooooooooo`0=oooo00<00?ooooooool0A?ooo`03o`00oooooooo00Koool00`00ooooooooo`0=
oooo00<00?ooooooool01Oooo`03o`00oooooooo02?oool001[oool00`000?ooooooo`0Toooo00<0
0?ooooooool03_ooo`03003ooooooooo04Coool00ol00?ooooooo`05oooo00<00?ooooooool03_oo
o`03003ooooooooo00Koool00ol00?ooooooo`0Roooo000Joooo00<0003oooooool09?ooo`03003o
oooooooo00ooool00`00ooooooooo`12oooo00?o003oooooool01_ooo`03003ooooooooo00koool0
0`00ooooooooo`06oooo00?o003oooooool08_ooo`006_ooo`030000oooooooo02Coool00`00oooo
ooooo`0?oooo00<00?ooooooool0@_ooo`03o`00oooooooo00Koool00`00ooooooooo`0?oooo00<0
0?ooooooool01_ooo`03o`00oooooooo027oool001[oool00`000?ooooooo`0Toooo00<00?oooooo
ool03oooo`03003ooooooooo047oool00ol00?ooooooo`06oooo00<00?ooooooool04?ooo`03003o
oooooooo00Koool00ol00?ooooooo`0Qoooo000Joooo0P0002Goool00`00ooooooooo`0?oooo00<0
0?ooooooool0@Oooo`03o`00oooooooo00Koool00`00ooooooooo`0@oooo00<00?ooooooool01ooo
o`03o`00oooooooo023oool001[oool00`000?ooooooo`0Soooo00<00?ooooooool04Oooo`03003o
oooooooo03ooool00ol00?ooooooo`07oooo00<00?ooooooool04Oooo`03003ooooooooo00Koool0
0ol00?ooooooo`0Poooo000Joooo00<0003oooooool08oooo`03003ooooooooo017oool00`00oooo
ooooo`0ooooo00?o003oooooool01oooo`03003ooooooooo017oool00`00ooooooooo`07oooo00?o
003oooooool07oooo`006_ooo`030000oooooooo02?oool00`00ooooooooo`0Aoooo00<00?oooooo
ool0?_ooo`03o`00oooooooo00Ooool00`00ooooooooo`0Boooo00<00?ooooooool01oooo`03o`00
oooooooo01ooool001[oool00`000?ooooooo`0Soooo00<00?ooooooool04Oooo`03003ooooooooo
03koool00ol00?ooooooo`07oooo00<00?ooooooool04_ooo`03003ooooooooo00Soool00ol00?oo
ooooo`0Noooo000Joooo00<0003oooooool08_ooo`03003ooooooooo01?oool00`00ooooooooo`0l
oooo00?o003oooooool02?ooo`03003ooooooooo01?oool00`00ooooooooo`07oooo00?o003ooooo
ool07_ooo`006_ooo`030000oooooooo02;oool00`00ooooooooo`0Coooo00<00?ooooooool0??oo
o`03o`00oooooooo00Ooool00`00ooooooooo`0Doooo00<00?ooooooool02?ooo`03o`00oooooooo
01goool001[oool00`000?ooooooo`0Roooo00<00?ooooooool04oooo`03003ooooooooo03_oool0
0ol00?ooooooo`08oooo00<00?ooooooool05?ooo`03003ooooooooo00Soool00ol00?ooooooo`0M
oooo000Joooo00<0003oooooool08_ooo`03003ooooooooo01?oool00`00ooooooooo`0koooo00?o
003oooooool02?ooo`03003ooooooooo01Coool00`00ooooooooo`09oooo00?o003oooooool07?oo
o`006_ooo`030000oooooooo027oool00`00ooooooooo`0Eoooo00<00?ooooooool0>Oooo`03o`00
oooooooo00Woool00`00ooooooooo`0Eoooo00<00?ooooooool02?ooo`03o`00oooooooo01coool0
01[oool200008_ooo`03003ooooooooo01Goool00`00ooooooooo`0ioooo00?o003oooooool02?oo
o`03003ooooooooo01Koool00`00ooooooooo`09oooo00?o003oooooool06oooo`006_ooo`030000
oooooooo027oool00`00ooooooooo`0Eoooo00<00?ooooooool0>Oooo`03o`00oooooooo00Soool0
0`00ooooooooo`0Foooo00<00?ooooooool02Oooo`03o`00oooooooo01_oool001[oool00`000?oo
ooooo`0Qoooo00<00?ooooooool05Oooo`03003ooooooooo03Soool00ol00?ooooooo`09oooo00<0
0?ooooooool05_ooo`03003ooooooooo00[oool00ol00?ooooooo`0Joooo000Joooo00<0003ooooo
ool08?ooo`03003ooooooooo01Ooool00`00ooooooooo`0goooo00?o003oooooool02Oooo`03003o
oooooooo01Koool00`00ooooooooo`0:oooo00?o003oooooool06_ooo`006_ooo`030000oooooooo
023oool00`00ooooooooo`0Goooo00<00?ooooooool0=_ooo`03o`00oooooooo00Woool00`00oooo
ooooo`0Hoooo00<00?ooooooool02_ooo`03o`00oooooooo01Woool001[oool00`000?ooooooo`0P
oooo00<00?ooooooool05oooo`03003ooooooooo03Koool00ol00?ooooooo`09oooo00<00?oooooo
ool06?ooo`03003ooooooooo00[oool00ol00?ooooooo`0Ioooo000Joooo00<0003oooooool08?oo
o`03003ooooooooo01Ooool00`00ooooooooo`0eoooo00?o003oooooool02_ooo`03003ooooooooo
01Soool00`00ooooooooo`0:oooo00?o003oooooool06Oooo`006_ooo`030000oooooooo01ooool0
0`00ooooooooo`0Ioooo00<00?ooooooool0=?ooo`03o`00oooooooo00[oool00`00ooooooooo`0H
oooo00<00?ooooooool02oooo`03o`00oooooooo01Soool001[oool00`000?ooooooo`0Ooooo00<0
0?ooooooool06Oooo`03003ooooooooo03Coool00ol00?ooooooo`0:oooo00<00?ooooooool06?oo
o`03003ooooooooo00_oool00ol00?ooooooo`0Hoooo000Joooo0P00023oool00`00ooooooooo`0I
oooo00<00?ooooooool0<oooo`03o`00oooooooo00[oool00`00ooooooooo`0Ioooo00<00?oooooo
ool03?ooo`03o`00oooooooo01Ooool001[oool00`000?ooooooo`0Ooooo00<00?ooooooool06Ooo
o`03003ooooooooo03?oool00ol00?ooooooo`0:oooo00<00?ooooooool06_ooo`03003ooooooooo
00_oool00ol00?ooooooo`0Goooo000Joooo00<0003oooooool07_ooo`03003ooooooooo01[oool0
0`00ooooooooo`0boooo00?o003oooooool02oooo`03003ooooooooo01[oool00`00ooooooooo`0<
oooo00?o003oooooool05_ooo`006_ooo`030000oooooooo01koool00`00ooooooooo`0Koooo00<0
0?ooooooool0<Oooo`03o`00oooooooo00_oool00`00ooooooooo`0Joooo00<00?ooooooool03?oo
o`03o`00oooooooo01Koool001[oool00`000?ooooooo`0Noooo00<00?ooooooool06oooo`03003o
oooooooo037oool00ol00?ooooooo`0;oooo00<00?ooooooool06_ooo`03003ooooooooo00coool0
0ol00?ooooooo`0Foooo000Joooo00<0003oooooool07_ooo`03003ooooooooo01_oool00`00oooo
ooooo`0`oooo00?o003oooooool02oooo`03003ooooooooo01_oool00`00ooooooooo`0=oooo00?o
003oooooool05Oooo`006_ooo`030000oooooooo01goool00`00ooooooooo`0Loooo00<00?oooooo
ool0<?ooo`03o`00oooooooo00_oool00`00ooooooooo`0Loooo00<00?ooooooool03?ooo`03o`00
oooooooo01Goool001[oool00`000?ooooooo`0Moooo00<00?ooooooool07Oooo`03003ooooooooo
02koool00ol00?ooooooo`0<oooo00<00?ooooooool07?ooo`03003ooooooooo00goool00ol00?oo
ooooo`0Doooo000;oooo00<0003oooooool00_ooo`030000oooooooo00;oool00`000?ooooooo`02
oooo00<0003oooooool07Oooo`03003ooooooooo01goool00`00ooooooooo`0^oooo00?o003ooooo
ool03?ooo`03003ooooooooo01coool00`00ooooooooo`0=oooo00?o003oooooool05?ooo`002_oo
o`030000oooo000000Ooool00`000?ooo`000003oooo00<0003oooooool07Oooo`03003ooooooooo
01goool00`00ooooooooo`0]oooo00?o003oooooool03Oooo`03003ooooooooo01coool00`00oooo
ooooo`0>oooo00?o003oooooool04oooo`001Oooo`<00002oooo00<0003oool000002Oooo`040000
oooooooooooo0P0001koool00`00ooooooooo`0Moooo00<00?ooooooool0;Oooo`03o`00oooooooo
00coool00`00ooooooooo`0Moooo00<00?ooooooool03_ooo`03o`00oooooooo01?oool000[oool0
0`000?ooo`000007oooo0P0000Coool00`000?ooooooo`0Moooo00<00?ooooooool07Oooo`03003o
oooooooo02goool00ol00?ooooooo`0<oooo00<00?ooooooool07_ooo`03003ooooooooo00goool0
0ol00?ooooooo`0Coooo000:oooo00<0003oool000001oooo`030000oooooooo00?oool00`000?oo
ooooo`0Loooo00<00?ooooooool07oooo`03003ooooooooo02_oool00ol00?ooooooo`0=oooo00<0
0?ooooooool07_ooo`03003ooooooooo00koool00ol00?ooooooo`0Boooo000;oooo00<0003ooooo
ool01_ooo`<00003oooo00<0003oooooool07?ooo`03003ooooooooo01ooool00`00ooooooooo`0[
oooo00?o003oooooool03Oooo`03003ooooooooo01koool00`00ooooooooo`0>oooo00?o003ooooo
ool04_ooo`006_ooo`030000oooooooo01coool00`00ooooooooo`0Ooooo00<00?ooooooool0:ooo
o`03o`00oooooooo00goool00`00ooooooooo`0Noooo00<00?ooooooool03_ooo`03o`00oooooooo
01;oool001[oool00`000?ooooooo`0Loooo00<00?ooooooool07oooo`03003ooooooooo02[oool0
0ol00?ooooooo`0=oooo00<00?ooooooool07oooo`03003ooooooooo00ooool00ol00?ooooooo`0A
oooo000Joooo00<0003oooooool07?ooo`03003ooooooooo01ooool00`00ooooooooo`0Zoooo00?o
003oooooool03Oooo`03003ooooooooo01ooool00`00ooooooooo`0?oooo00?o003oooooool04Ooo
o`006_ooo`030000oooooooo01coool00`00ooooooooo`0Ooooo00<00?ooooooool0:_ooo`03o`00
oooooooo00goool00`00ooooooooo`0Poooo00<00?ooooooool03_ooo`03o`00oooooooo017oool0
01[oool00`000?ooooooo`0Koooo00<00?ooooooool08Oooo`03003ooooooooo02Soool00ol00?oo
ooooo`0>oooo00<00?ooooooool08?ooo`03003ooooooooo00ooool00ol00?ooooooo`0@oooo000J
oooo00<0003oooooool06oooo`03003ooooooooo027oool00`00ooooooooo`0Xoooo00?o003ooooo
ool03_ooo`03003ooooooooo023oool00`00ooooooooo`0?oooo00?o003oooooool04?ooo`006_oo
o`80000Loooo00<00?ooooooool08Oooo`03003ooooooooo02Soool00ol00?ooooooo`0>oooo00<0
0?ooooooool08?ooo`03003ooooooooo00ooool00ol00?ooooooo`0@oooo000Joooo00<0003ooooo
ool06oooo`03003ooooooooo027oool00`00ooooooooo`0Woooo00?o003oooooool03_ooo`03003o
oooooooo027oool00`00ooooooooo`0@oooo00?o003oooooool03oooo`006_ooo`030000oooooooo
01_oool00`00ooooooooo`0Qoooo00<00?ooooooool09oooo`03o`00oooooooo00koool00`00oooo
ooooo`0Roooo00<00?ooooooool03oooo`03o`00oooooooo00ooool001[oool00`000?ooooooo`0K
oooo00<00?ooooooool08Oooo`03003ooooooooo02Koool00ol00?ooooooo`0?oooo00<00?oooooo
ool08_ooo`03003ooooooooo013oool00ol00?ooooooo`0>oooo000Joooo00<0003oooooool06_oo
o`03003ooooooooo02?oool00`00ooooooooo`0Uoooo00?o003oooooool03oooo`03003ooooooooo
02;oool00`00ooooooooo`0@oooo00?o003oooooool03_ooo`006_ooo`030000oooooooo01[oool0
0`00ooooooooo`0Soooo00<00?ooooooool09Oooo`03o`00oooooooo00ooool00`00ooooooooo`0R
oooo00<00?ooooooool04?ooo`03o`00oooooooo00koool001[oool00`000?ooooooo`0Joooo00<0
0?ooooooool08oooo`03003ooooooooo02Coool00ol00?ooooooo`0@oooo00<00?ooooooool08_oo
o`03003ooooooooo017oool00ol00?ooooooo`0=oooo000Joooo00<0003oooooool06_ooo`03003o
oooooooo02?oool00`00ooooooooo`0Toooo00?o003oooooool03oooo`03003ooooooooo02?oool0
0`00ooooooooo`0Aoooo00?o003oooooool03Oooo`006_ooo`030000oooooooo01[oool00`00oooo
ooooo`0Soooo00<00?ooooooool09?ooo`03o`00oooooooo00ooool00`00ooooooooo`0Toooo00<0
0?ooooooool04?ooo`03o`00oooooooo00goool001[oool200006oooo`03003ooooooooo02?oool0
0`00ooooooooo`0Soooo00?o003oooooool04?ooo`03003ooooooooo02Coool00`00ooooooooo`0A
oooo00?o003oooooool03?ooo`006_ooo`030000oooooooo01Woool00`00ooooooooo`0Uoooo00<0
0?ooooooool08_ooo`03o`00oooooooo013oool00`00ooooooooo`0Toooo00<00?ooooooool04Ooo
o`03o`00oooooooo00coool001[oool00`000?ooooooo`0Ioooo00<00?ooooooool09Oooo`03003o
oooooooo02;oool00ol00?ooooooo`0@oooo00<00?ooooooool09?ooo`03003ooooooooo017oool0
0ol00?ooooooo`0<oooo000Joooo00<0003oooooool06Oooo`03003ooooooooo02Goool00`00oooo
ooooo`0Qoooo00?o003oooooool04Oooo`03003ooooooooo02Coool00`00ooooooooo`0Boooo00?o
003oooooool02oooo`006_ooo`030000oooooooo01Woool00`00ooooooooo`0Uoooo00<00?oooooo
ool08Oooo`03o`00oooooooo013oool00`00ooooooooo`0Uoooo00<00?ooooooool04_ooo`03o`00
oooooooo00_oool001[oool00`000?ooooooo`0Ioooo00<00?ooooooool09Oooo`03003ooooooooo
027oool00ol00?ooooooo`0@oooo00<00?ooooooool09_ooo`03003ooooooooo017oool00ol00?oo
ooooo`0;oooo000Joooo00<0003oooooool06Oooo`03003ooooooooo02Goool00`00ooooooooo`0P
oooo00?o003oooooool04Oooo`03003ooooooooo02Koool00`00ooooooooo`0Boooo00?o003ooooo
ool02_ooo`006_ooo`030000oooooooo01Soool00`00ooooooooo`0Woooo00<00?ooooooool07ooo
o`03o`00oooooooo017oool00`00ooooooooo`0Voooo00<00?ooooooool04_ooo`03o`00oooooooo
00[oool001[oool00`000?ooooooo`0Hoooo00<00?ooooooool09oooo`03003ooooooooo01ooool0
0ol00?ooooooo`0Aoooo00<00?ooooooool09_ooo`03003ooooooooo01;oool00ol00?ooooooo`0:
oooo000Joooo00<0003oooooool06?ooo`03003ooooooooo02Ooool00`00ooooooooo`0Noooo00?o
003oooooool04_ooo`03003ooooooooo02Koool00`00ooooooooo`0Coooo00?o003oooooool02Ooo
o`006_ooo`80000Ioooo00<00?ooooooool09oooo`03003ooooooooo01koool00ol00?ooooooo`0A
oooo00<00?ooooooool0:?ooo`03003ooooooooo01;oool00ol00?ooooooo`09oooo000Joooo00<0
003oooooool06?ooo`03003ooooooooo02Ooool00`00ooooooooo`0Noooo00?o003oooooool04Ooo
o`03003ooooooooo02Soool00`00ooooooooo`0Boooo00?o003oooooool02Oooo`006_ooo`030000
oooooooo01Soool00`00ooooooooo`0Woooo00<00?ooooooool07Oooo`03o`00oooooooo01;oool0
0`00ooooooooo`0Xoooo00<00?ooooooool04_ooo`03o`00oooooooo00Woool001[oool00`000?oo
ooooo`0Goooo00<00?ooooooool0:Oooo`03003ooooooooo01coool00ol00?ooooooo`0Boooo00<0
0?ooooooool0:?ooo`03003ooooooooo01?oool00ol00?ooooooo`08oooo000Joooo00<0003ooooo
ool05oooo`03003ooooooooo02Woool00`00ooooooooo`0Loooo00?o003oooooool04_ooo`03003o
oooooooo02Soool00`00ooooooooo`0Coooo00?o003oooooool02?ooo`006_ooo`030000oooooooo
01Ooool00`00ooooooooo`0Yoooo00<00?ooooooool06oooo`03o`00oooooooo01?oool00`00oooo
ooooo`0Xoooo00<00?ooooooool04oooo`03o`00oooooooo00Soool001[oool00`000?ooooooo`0G
oooo00<00?ooooooool0:Oooo`03003ooooooooo01_oool00ol00?ooooooo`0Boooo00<00?oooooo
ool0:_ooo`03003ooooooooo01?oool00ol00?ooooooo`07oooo000Joooo00<0003oooooool05ooo
o`03003ooooooooo02Woool00`00ooooooooo`0Joooo00?o003oooooool04oooo`03003ooooooooo
02[oool00`00ooooooooo`0Coooo00?o003oooooool01oooo`006_ooo`030000oooooooo01Ooool0
0`00ooooo`00000400006oooo`<00007oooo00<00?ooooooool04Oooo`800007oooo00?o003ooooo
ool04oooo`04003o0000000000006oooo`030000oooooooo00_oool00`00ooooooooo`0=oooo0P00
00Coool00ol00?ooooooo`07oooo000Joooo0P0001Ooool00`00ooooooooo`02oooo00<0003ooooo
ool06oooo`030000oooooooo00Soool00`00ooooooooo`0Boooo00<0003oooooool01?ooo`03o`00
oooooooo01?oool00`00ooooo`00000Koooo00<0003oool000003?ooo`03003ooooooooo00goool0
0`000?ooo`000004oooo00?o003oooooool01_ooo`006_ooo`030000oooooooo01Koool00`00oooo
ooooo`02oooo00<0003oooooool07?ooo`030000oooooooo00Ooool00`00ooooooooo`0Aoooo00<0
003oooooool01?ooo`03o`00oooooooo01Coool01000o`000000000001coool00`000?ooooooo`0:
oooo00<00?ooooooool03Oooo`030000oooo000000Coool00ol00?ooooooo`06oooo000Joooo00<0
003oooooool05_ooo`03003ooooooooo00;oool00`000?ooooooo`0Loooo00<0003oooooool01ooo
o`03003ooooooooo01;oool00`000?ooooooo`03oooo00?o003oooooool05?ooo`03003ooooo0000
01_oool200003_ooo`03003ooooooooo00coool200001Oooo`03o`00oooooooo00Koool001[oool0
0`000?ooooooo`0Foooo00<00?ooooooool00_ooo`030000oooooooo01_oool00`000?ooo`000008
oooo00<00?ooooooool04?ooo`030000oooo000000Goool00ol00?ooooooo`0Coooo00@00?ooool0
0000000Koooo00<0003oooooool03Oooo`03003ooooooooo00coool00`000?ooooooo`04oooo00?o
003oooooool01_ooo`006_ooo`030000oooooooo01Koool01000ooooooooooooo`80000Noooo00<0
003oooooool01oooo`03003ooooooooo017oool00`000?ooooooo`03oooo00?o003oooooool05?oo
o`04003ooooooooo00006oooo`<0000=oooo00<00?ooooooool03Oooo`800005oooo00?o003ooooo
ool01Oooo`006_ooo`030000oooooooo01Koool00`00ooooooooo`0[oooo00<00?ooooooool05ooo
o`03o`00oooooooo01Coool00`00ooooooooo`0/oooo00<00?ooooooool05?ooo`03o`00oooooooo
00Goool001[oool00`000?ooooooo`0Eoooo00<00?ooooooool0;Oooo`03003ooooooooo01Koool0
0ol00?ooooooo`0Doooo00<00?ooooooool0;?ooo`03003ooooooooo01Coool00ol00?ooooooo`05
oooo000Joooo00<0003oooooool05Oooo`03003ooooooooo02goool00`00ooooooooo`0Eoooo00?o
003oooooool05Oooo`03003ooooooooo02coool00`00ooooooooo`0Eoooo00?o003oooooool01?oo
o`006_ooo`030000oooooooo01Goool00`00ooooooooo`0]oooo00<00?ooooooool05Oooo`03o`00
oooooooo01Goool00`00ooooooooo`0]oooo00<00?ooooooool05?ooo`03o`00oooooooo00Coool0
01[oool00`000?ooooooo`0Eoooo00<00?ooooooool0;Oooo`03003ooooooooo01Goool00ol00?oo
ooooo`0Doooo00<00?ooooooool0;_ooo`03003ooooooooo01Coool00ol00?ooooooo`04oooo000E
oooo1@000003o`000000000001D000000`00o`000000000]000000<00?l00000000050000003o`00
0000000001D000000`00o`000000000^000000<00?l0000000005@000003o`000000000000<00000
01[oool00ol00?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?oo
ooooo`03oooo00<00?ooooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0
003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool00ooo
o`030000oooooooo00;oool00`00o`000?ooo`04oooo00<0003oooooool00oooo`030000oooooooo
00Coool010000?ooooooool000;oool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000
oooooooo00?oool010000?ooooooo`00o`;oool00`000?ooooooo`03oooo00<0003oooooool00ooo
o`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo
00?oool00`000?ooooooo`03oooo00@0003oooooool00?l2oooo00<0003oooooool00oooo`030000
oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool00oooo`400001oooo0Oooo`006_oo
o`030000o`00oooo01Coool00`00ooooooooo`0_oooo00<00?ooooooool04oooo`03o`00oooooooo
01Goool00`00ooooooooo`0^oooo00<00?ooooooool06oooo`006_ooo`030000o`00oooo01Coool0
0`00ooooooooo`0_oooo00<00?ooooooool04_ooo`03o`00oooooooo01Koool00`00ooooooooo`0^
oooo00<00?ooooooool06oooo`006_ooo`030000o`00oooo01Coool00`00ooooooooo`0_oooo00<0
0?ooooooool04_ooo`03o`00oooooooo01Koool00`00ooooooooo`0_oooo00<00?ooooooool06_oo
o`006_ooo`030000ooooo`0001Coool00`00ooooooooo`0_oooo00<00?ooooooool04_ooo`03o`00
oooooooo01Koool00`00ooooooooo`0_oooo00<00?ooooooool06_ooo`006_ooo`030000ooooo`00
01Coool00`00ooooooooo`0_oooo00<00?ooooooool04_ooo`03o`00oooooooo01Goool00`00oooo
ooooo`0`oooo00<00?ooooooool06_ooo`006_ooo`030000ooooo`0001Coool00`00ooooooooo`0_
oooo00<00?ooooooool04Oooo`03o`00oooooooo01Koool00`00ooooooooo`0`oooo00<00?oooooo
ool06_ooo`006_ooo`040000ooooooooo`004_ooo`03003ooooooooo037oool00`00ooooooooo`0@
oooo00?o003oooooool05_ooo`03003ooooooooo033oool00`00ooooooooo`0Joooo000Joooo00@0
003ooooooooo000Boooo00<00?ooooooool0<Oooo`03003ooooooooo013oool00ol00?ooooooo`0F
oooo00<00?ooooooool0<?ooo`03003ooooooooo01[oool001[oool2000000?ooooo003oool04Ooo
o`03003ooooooooo037oool00`00ooooooooo`0?oooo00?o003oooooool05oooo`03003ooooooooo
037oool00`00ooooooooo`0Ioooo000Joooo00D0003ooooooooooooo00004Oooo`03003ooooooooo
037oool00`00ooooooooo`0?oooo00?o003oooooool05oooo`03003ooooooooo037oool00`00oooo
ooooo`0Ioooo000Joooo00D0003ooooooooooooo00004Oooo`03003ooooooooo037oool00`00oooo
ooooo`0?oooo00?o003oooooool05_ooo`03003ooooooooo03;oool00`00ooooooooo`0Ioooo000J
oooo00D0003ooooooooooooo00004Oooo`03003ooooooooo037oool00`00ooooooooo`0?oooo00?o
003oooooool05_ooo`03003ooooooooo03;oool00`00ooooooooo`0Ioooo000Joooo00<0003ooooo
ool00_ooo`03o`00oooooooo00goool00`00ooooooooo`0boooo00<00?ooooooool03_ooo`03o`00
oooooooo01Ooool00`00ooooooooo`0boooo00<00?ooooooool06Oooo`006_ooo`030000oooooooo
00;oool00ol00?ooooooo`0=oooo00<00?ooooooool0<oooo`03003ooooooooo00goool00ol00?oo
ooooo`0Goooo00<00?ooooooool0<_ooo`03003ooooooooo01Woool001[oool00`000?ooooooo`02
oooo00?o003oooooool03Oooo`03003ooooooooo03?oool00`00ooooooooo`0=oooo00?o003ooooo
ool05oooo`03003ooooooooo03?oool00`00ooooooooo`0Hoooo000Joooo00<0003oooooool00ooo
o`03o`00oooooooo00coool00`00ooooooooo`0coooo00<00?ooooooool03Oooo`03o`00oooooooo
01Ooool00`00ooooooooo`0coooo00<00?ooooooool06?ooo`006_ooo`030000oooooooo00?oool0
0ol00?ooooooo`0<oooo00<00?ooooooool0<oooo`03003ooooooooo00coool00ol00?ooooooo`0G
oooo00<00?ooooooool0=?ooo`03003ooooooooo01Soool001[oool200001?ooo`03o`00oooooooo
00coool00`00ooooooooo`0coooo00<00?ooooooool03?ooo`03o`00oooooooo01Ooool00`00oooo
ooooo`0doooo00<00?ooooooool06?ooo`006_ooo`030000oooooooo00Coool00ol00?ooooooo`0:
oooo00<00?ooooooool0=?ooo`03003ooooooooo00coool00ol00?ooooooo`0Goooo00<00?oooooo
ool0=?ooo`03003ooooooooo01Soool001[oool00`000?ooooooo`04oooo00?o003oooooool02_oo
o`03003ooooooooo03Coool00`00ooooooooo`0;oooo00?o003oooooool06?ooo`03003ooooooooo
03Coool00`00ooooooooo`0Hoooo000Joooo00<0003oooooool01?ooo`03o`00oooooooo00[oool0
0`00ooooooooo`0eoooo00<00?ooooooool02_ooo`03o`00oooooooo01Soool00`00ooooooooo`0e
oooo00<00?ooooooool05oooo`006_ooo`030000oooooooo00Goool00ol00?ooooooo`09oooo00<0
0?ooooooool0=Oooo`03003ooooooooo00[oool00ol00?ooooooo`0Hoooo00<00?ooooooool0=Ooo
o`03003ooooooooo01Ooool001[oool00`000?ooooooo`05oooo00?o003oooooool02Oooo`03003o
oooooooo03Goool00`00ooooooooo`0:oooo00?o003oooooool05oooo`03003ooooooooo03Koool0
0`00ooooooooo`0Goooo000Joooo00<0003oooooool01Oooo`03o`00oooooooo00Woool00`00oooo
ooooo`0eoooo00<00?ooooooool02Oooo`03o`00oooooooo01Soool00`00ooooooooo`0foooo00<0
0?ooooooool05oooo`006_ooo`030000oooooooo00Koool00ol00?ooooooo`07oooo00<00?oooooo
ool0=_ooo`03003ooooooooo00Woool00ol00?ooooooo`0Hoooo00<00?ooooooool0=_ooo`03003o
oooooooo01Ooool001[oool00`000?ooooooo`06oooo00?o003oooooool01oooo`03003ooooooooo
03Koool00`00ooooooooo`09oooo00?o003oooooool06?ooo`03003ooooooooo03Koool00`00oooo
ooooo`0Goooo000Joooo00<0003oooooool01_ooo`03o`00oooooooo00Ooool00`00ooooooooo`0g
oooo00<00?ooooooool01oooo`03o`00oooooooo01Woool00`00ooooooooo`0goooo00<00?oooooo
ool05_ooo`006_ooo`800008oooo00?o003oooooool01_ooo`03003ooooooooo03Ooool00`00oooo
ooooo`07oooo00?o003oooooool06Oooo`03003ooooooooo03Ooool00`00ooooooooo`0Foooo000J
oooo00<0003oooooool01oooo`03o`00oooooooo00Koool00`00ooooooooo`0goooo00<00?oooooo
ool01_ooo`03o`00oooooooo01Woool00`00ooooooooo`0hoooo00<00?ooooooool05_ooo`006_oo
o`030000oooooooo00Ooool00ol00?ooooooo`06oooo00<00?ooooooool0=oooo`03003ooooooooo
00Koool00ol00?ooooooo`0Ioooo00<00?ooooooool0>?ooo`03003ooooooooo01Koool001[oool0
0`000?ooooooo`08oooo00?o003oooooool01?ooo`03003ooooooooo03Soool00`00ooooooooo`06
oooo00?o003oooooool06Oooo`03003ooooooooo03Soool00`00ooooooooo`0Foooo000Joooo00<0
003oooooool02?ooo`03o`00oooooooo00Coool00`00ooooooooo`0hoooo00<00?ooooooool01Ooo
o`03o`00oooooooo01[oool00`00ooooooooo`0hoooo00<00?ooooooool05_ooo`006_ooo`030000
oooooooo00Soool00ol00?ooooooo`04oooo00<00?ooooooool0>?ooo`03003ooooooooo00Goool0
0ol00?ooooooo`0Joooo00<00?ooooooool0>Oooo`03003ooooooooo01Goool001[oool00`000?oo
ooooo`09oooo00?o003oooooool00oooo`03003ooooooooo03Woool00`00ooooooooo`03oooo00?o
003oooooool06oooo`03003ooooooooo03Woool00`00ooooooooo`0Eoooo000Joooo00<0003ooooo
ool02Oooo`03o`00oooooooo00?oool00`00ooooooooo`0ioooo00<00?ooooooool00oooo`03o`00
oooooooo01[oool00`00ooooooooo`0joooo00<00?ooooooool05Oooo`006_ooo`030000oooooooo
00Woool00ol00?ooooooo`03oooo00<00?ooooooool0>Oooo`03003ooooooooo00?oool00ol00?oo
ooooo`0Joooo00<00?ooooooool0>_ooo`03003ooooooooo01Goool001[oool200002_ooo`03o`00
oooooooo00;oool00`00ooooooooo`0joooo00<00?ooooooool00_ooo`03o`00oooooooo01_oool0
0`00ooooooooo`0joooo00<00?ooooooool05Oooo`006_ooo`030000oooooooo00[oool01Ol00?oo
ooooooooo`00o`0loooo00<00?ooooooool00_ooo`03o`00oooooooo01_oool00`00ooooooooo`0j
oooo00<00?ooooooool05Oooo`006_ooo`030000oooooooo00[oool01Ol00?ooooooooooo`00o`0l
oooo00<00?ooooooool00_ooo`03o`00oooooooo01_oool00`00ooooooooo`0koooo00<00?oooooo
ool05?ooo`006_ooo`030000oooooooo00[oool01Ol00?ooooooooooo`00o`0moooo00@00?oooooo
oooo000Noooo00<00?ooooooool0>oooo`03003ooooooooo01Coool001[oool00`000?ooooooo`0;
oooo00Co003oooooool00?lmoooo00@00?oooooooooo000Moooo00<00?ooooooool0??ooo`03003o
oooooooo01Coool001[oool00`000?ooooooo`0;oooo00Co003oooooool00?lmoooo00<00?oooooo
00007_ooo`03003ooooooooo03coool00`00ooooooooo`0Doooo000Joooo00<0003oooooool02ooo
o`03o`00oooo003o03koool00`00ooooool0000Noooo00<00?ooooooool0??ooo`03003ooooooooo
01Coool001[oool00`000?ooooooo`0<oooo00?o00000?ooool0?Oooo`03003oooooo`0001koool0
0`00ooooooooo`0loooo00<00?ooooooool05?ooo`002oooo`030000oooooooo00;oool00`000?oo
ooooo`02oooo00<0003oooooool00_ooo`030000oooooooo00coool00ol00000ooooo`0moooo00<0
0?oo003oool07_ooo`03003ooooooooo03goool00`00ooooooooo`0Coooo000:oooo00<0003oool0
00001oooo`030000oooo000000?oool00`000?ooooooo`0<oooo00?o00000?ooool0?_ooo`03003o
oooooooo01goool00`00ooooooooo`0moooo00<00?ooooooool04oooo`002_ooo`030000oooo0000
00Woool010000?ooooooooooo`80000>oooo00<00?ooooooool0??ooo`03o`00003ooooo01goool0
0`00ooooooooo`0noooo00<00?ooooooool04oooo`002_ooo`030000oooo000000Ooool200001?oo
o`030000oooooooo00coool00`00ool00?ooo`0moooo00?o00000?ooool07Oooo`03003ooooooooo
03koool00`00ooooooooo`0Coooo000:oooo00<0003oool000001oooo`030000oooooooo00?oool0
0`000?ooooooo`0<oooo00<00?oo003oool0?Oooo`03o`00003ooooo01goool00`00ooooooooo`0n
oooo00<00?ooooooool04oooo`002oooo`030000oooooooo00Koool300000oooo`030000oooooooo
00coool00`00ooooool0000loooo00Co003oooooool00?lMoooo00<00?ooooooool0?_ooo`03003o
oooooooo01?oool001[oool00`000?ooooooo`0<oooo00<00?oooooo0000??ooo`04o`00oooooooo
003o7Oooo`03003ooooooooo03ooool00`00ooooooooo`0Boooo000Joooo00<0003oooooool03?oo
o`04003oooooooooo`00>oooo`04o`00oooooooo003o7Oooo`03003ooooooooo03ooool00`00oooo
ooooo`0Boooo000Joooo00<0003oooooool02oooo`05003oooooooooooooo`0003[oool01Ol00?oo
ooooooooo`00o`0Loooo00<00?ooooooool0@?ooo`03003ooooooooo01;oool001[oool00`000?oo
ooooo`0;oooo00<00?ooooooool00_ooo`03o`00oooooooo03Ooool01Ol00?ooooooooooo`00o`0L
oooo00<00?ooooooool0@?ooo`03003ooooooooo01;oool001[oool00`000?ooooooo`0;oooo00<0
0?ooooooool00_ooo`03o`00oooooooo03Koool00ol00?ooooooo`03oooo00<00?ooooooool06Ooo
o`03003ooooooooo043oool00`00ooooooooo`0Boooo000Joooo00<0003oooooool02oooo`03003o
oooooooo00;oool00ol00?ooooooo`0foooo00?o003oooooool00oooo`03003ooooooooo01Woool0
0`00ooooooooo`10oooo00<00?ooooooool04_ooo`006_ooo`80000<oooo00<00?ooooooool00ooo
o`03o`00oooooooo03Goool00ol00?ooooooo`03oooo00<00?ooooooool06Oooo`03003ooooooooo
047oool00`00ooooooooo`0Aoooo000Joooo00<0003oooooool02oooo`03003ooooooooo00?oool0
0ol00?ooooooo`0doooo00?o003oooooool01?ooo`03003ooooooooo01Soool00`00ooooooooo`12
oooo00<00?ooooooool04Oooo`006_ooo`030000oooooooo00[oool00`00ooooooooo`05oooo00?o
003oooooool0<oooo`03o`00oooooooo00Goool00`00ooooooooo`0Goooo00<00?ooooooool0@_oo
o`03003ooooooooo017oool001[oool00`000?ooooooo`0:oooo00<00?ooooooool01Oooo`03o`00
oooooooo03?oool00ol00?ooooooo`05oooo00<00?ooooooool05oooo`03003ooooooooo04;oool0
0`00ooooooooo`0Aoooo000Joooo00<0003oooooool02_ooo`03003ooooooooo00Goool00ol00?oo
ooooo`0boooo00?o003oooooool01_ooo`03003ooooooooo01Ooool00`00ooooooooo`12oooo00<0
0?ooooooool04Oooo`006_ooo`030000oooooooo00[oool00`00ooooooooo`06oooo00?o003ooooo
ool0<Oooo`03o`00oooooooo00Koool00`00ooooooooo`0Goooo00<00?ooooooool0@_ooo`03003o
oooooooo017oool001[oool00`000?ooooooo`0:oooo00<00?ooooooool01_ooo`03o`00oooooooo
033oool00ol00?ooooooo`08oooo00<00?ooooooool05Oooo`03003ooooooooo04Coool00`00oooo
ooooo`0@oooo000Joooo00<0003oooooool02Oooo`03003ooooooooo00Soool00ol00?ooooooo`0_
oooo00?o003oooooool02?ooo`03003ooooooooo01Goool00`00ooooooooo`14oooo00<00?oooooo
ool04?ooo`006_ooo`030000oooooooo00Woool00`00ooooooooo`08oooo00?o003oooooool0;ooo
o`03o`00oooooooo00Soool00`00ooooooooo`0Eoooo00<00?ooooooool0A?ooo`03003ooooooooo
013oool001[oool200002_ooo`03003ooooooooo00Woool00ol00?ooooooo`0]oooo00?o003ooooo
ool02Oooo`03003ooooooooo01Goool00`00ooooooooo`14oooo00<00?ooooooool04?ooo`006_oo
o`030000oooooooo00Woool00`00ooooooooo`09oooo00?o003oooooool0;Oooo`03o`00oooooooo
00Woool00`00ooooooooo`0Eoooo00<00?ooooooool0A?ooo`03003ooooooooo013oool001[oool0
0`000?ooooooo`09oooo00<00?ooooooool02_ooo`03o`00oooooooo02_oool00ol00?ooooooo`0;
oooo00<00?ooooooool04oooo`03003ooooooooo04Koool00`00ooooooooo`0?oooo000Joooo00<0
003oooooool02?ooo`03003ooooooooo00_oool00ol00?ooooooo`0[oooo00?o003oooooool02ooo
o`03003ooooooooo01?oool00`00ooooooooo`16oooo00<00?ooooooool03oooo`006_ooo`030000
oooooooo00Soool00`00ooooooooo`0<oooo00?o003oooooool0:Oooo`03o`00oooooooo00coool0
0`00ooooooooo`0Coooo00<00?ooooooool0A_ooo`03003ooooooooo00ooool001[oool00`000?oo
ooooo`08oooo00<00?ooooooool03?ooo`03o`00oooooooo02Woool00ol00?ooooooo`0<oooo00<0
0?ooooooool04oooo`03003ooooooooo04Ooool00`00ooooooooo`0>oooo000Joooo00<0003ooooo
ool02?ooo`03003ooooooooo00goool00ol00?ooooooo`0Woooo00?o003oooooool03Oooo`03003o
oooooooo01;oool00`00ooooooooo`18oooo00<00?ooooooool03_ooo`006_ooo`030000oooooooo
00Ooool00`00ooooooooo`0>oooo00?o003oooooool09oooo`03o`00oooooooo00koool00`00oooo
ooooo`0Aoooo00<00?ooooooool0BOooo`03003ooooooooo00goool001[oool00`000?ooooooo`07
oooo00<00?ooooooool03oooo`03o`00oooooooo02Goool00ol00?ooooooo`0?oooo00<00?oooooo
ool04Oooo`03003ooooooooo04Woool00`00ooooooooo`0=oooo000Joooo00<0003oooooool01ooo
o`03003ooooooooo00ooool00ol00?ooooooo`0Uoooo00?o003oooooool03oooo`03003ooooooooo
017oool00`00ooooooooo`19oooo00<00?ooooooool03Oooo`006_ooo`800008oooo00<00?oooooo
ool04?ooo`03o`00oooooooo02?oool00ol00?ooooooo`0@oooo00<00?ooooooool04?ooo`03003o
oooooooo04_oool00`00ooooooooo`0<oooo000Joooo00<0003oooooool01_ooo`03003ooooooooo
017oool00ol00?ooooooo`0Soooo00?o003oooooool04?ooo`03003ooooooooo013oool00`00oooo
ooooo`1;oooo00<00?ooooooool03?ooo`006_ooo`030000oooooooo00Koool00`00ooooooooo`0B
oooo00?o003oooooool08Oooo`03o`00oooooooo01;oool00`00ooooooooo`0?oooo00<00?oooooo
ool0Boooo`03003ooooooooo00coool001[oool00`000?ooooooo`06oooo00<00?ooooooool04_oo
o`03o`00oooooooo027oool00ol00?ooooooo`0Boooo00<00?ooooooool03oooo`03003ooooooooo
04_oool00`00ooooooooo`0<oooo000Joooo00<0003oooooool01_ooo`03003ooooooooo01?oool0
0ol00?ooooooo`0Ooooo00?o003oooooool04oooo`03003ooooooooo00koool00`00ooooooooo`1=
oooo00<00?ooooooool02oooo`006_ooo`030000oooooooo00Goool00`00ooooooooo`0Doooo00?o
003oooooool07oooo`03o`00oooooooo01?oool00`00ooooooooo`0>oooo00<00?ooooooool0COoo
o`03003ooooooooo00_oool001[oool00`000?ooooooo`05oooo00<00?ooooooool05Oooo`03o`00
oooooooo01goool00ol00?ooooooo`0Eoooo00<00?ooooooool03Oooo`03003ooooooooo04goool0
0`00ooooooooo`0;oooo000Joooo00<0003oooooool01Oooo`03003ooooooooo01Koool00ol00?oo
ooooo`0Koooo00?o003oooooool05_ooo`03003ooooooooo00goool00`00ooooooooo`1=oooo00<0
0?ooooooool02oooo`006_ooo`030000oooooooo00Goool00`00ooooooooo`0Goooo00?o003ooooo
ool06Oooo`03o`00oooooooo01Ooool00`00ooooooooo`0<oooo00<00?ooooooool0C_ooo`03003o
oooooooo00_oool001[oool200001Oooo`03003ooooooooo01Soool00ol00?ooooooo`0Ioooo00?o
003oooooool06?ooo`03003ooooooooo00_oool00`00ooooooooo`1?oooo00<00?ooooooool02_oo
o`006_ooo`030000oooooooo00Coool00`00ooooooooo`0Ioooo00?o003oooooool05oooo`03o`00
oooooooo01Woool00`00ooooooooo`0:oooo00<00?ooooooool0D?ooo`03003ooooooooo00[oool0
01[oool00`000?ooooooo`03oooo00<00?ooooooool06oooo`03o`00oooooooo01Goool00ol00?oo
ooooo`0Joooo00<00?ooooooool02_ooo`03003ooooooooo053oool00`00ooooooooo`0:oooo000J
oooo00<0003oooooool00oooo`03003ooooooooo01coool00ol00?ooooooo`0Coooo00?o003ooooo
ool07?ooo`03003ooooooooo00Soool00`00ooooooooo`1Aoooo00<00?ooooooool02_ooo`006_oo
o`030000oooooooo00;oool00`00ooooooooo`0Moooo00?o003oooooool04_ooo`03o`00oooooooo
01goool00`00ooooooooo`08oooo00<00?ooooooool0D_ooo`03003ooooooooo00Woool001[oool0
0`000?ooooooo`02oooo00<00?ooooooool07_ooo`03o`00oooooooo013oool00ol00?ooooooo`0N
oooo00<00?ooooooool01oooo`03003ooooooooo05Coool00`00ooooooooo`08oooo000Joooo00D0
003oooooooooool00?l08_ooo`03o`00oooooooo00koool00ol00?ooooooo`0Poooo00<00?oooooo
ool01_ooo`03003ooooooooo05Goool00`00ooooooooo`07oooo000Joooo00D0003oooooooooool0
0?l08oooo`03o`00oooooooo00coool00ol00?ooooooo`0Roooo00<00?ooooooool01?ooo`03003o
oooooooo05Koool00`00ooooooooo`07oooo000Coooo1@0000;oool010000?ooooooo`00obGoool2
o`002oooo`03o`00oooooooo02?oool00`00ooooooooo`04oooo00<00?ooooooool0Eoooo`03003o
oooooooo00Koool001Goool00`000?ooooooo`02oooo00<000000?l00?l0:?ooo`?o0005oooo0ol0
02Ooool3003o0_ooo`03003ooooooooo05Woool00`00ooooooooo`05oooo000Eoooo00<0003ooooo
ool00_ooo`800?l/oooo1Ol002coool3003oGOooo`800?l5oooo000Eoooo00<0003oooooool00_oo
o`030000oooooooo0<?oool001Goool00`000?ooooooo`02oooo00<0003oooooool0`oooo`005?oo
o`800004oooo00<0003oooooool0`oooo`006_ooo`030000oooooooo0<?oool001[oool00`000?oo
ooooo`33oooo003Poooo003Poooo003Poooo003Poooo003Poooo003Poooo003Poooo003Poooo003P
oooo003Poooo0000\
\>"],
  ImageRangeCache->{{{0, 223}, {223, 0}} -> {-0.869166, -1.16334, 0.0327779, 
  0.0104335}}]
}, Open  ]],

Cell[TextData[{
  "In an expression of the form g[x_^n_Integer, z_], the patterns are named \
with the symbols ",
  Cell[BoxData[
      \(TraditionalForm\`x, n, \)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ", but there is no name for the whole compound pattern x_^n_Integer. There \
is a way to give names to such compound patterns so that they can be referred \
to directly on the right-hand side. The syntax consists of a name followed by \
a colon followed by the compound pattern."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(g11[expr : x_^y_Real, z_] := z\ expr; 
    \n{g11[\((a + b - 2)\)^0.5, 2], g11[\((a + b - 2)\)^3, 2]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"2", " ", 
          SuperscriptBox[\((\(-2\) + a + b)\), 
            StyleBox["0.5`",
              StyleBoxAutoDelete->True,
              PrintPrecision->1]]}], ",", 
        \(g11[\((\(-2\) + a + b)\)\^3, 2]\)}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.2.4 Using Patterns in Rules", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  StyleBox["Patterns",
    FontColor->RGBColor[0, 0, 1]],
  " play an important role in both global and local rules."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell["1.2.4.1 Patterns in Global Rules", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
For example, it is very easy to give rewrite rules for differentiating \
polynomials of one variable.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(diff[x_^n_. , x_] := n\ x^\((n - 1)\); \n
    diff[a_ + b_, x_] := diff[a, x] + diff[b, x]; \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Notice the default value for ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " in the first rule. Try it out on some typical functions."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({diff[y, y], diff[z^2.1, z], diff[u^2 + v^3, u]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"1", ",", 
        RowBox[{
          StyleBox["2.10000000000000008`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2], " ", \(z\^1.10000000000000008`\)}], ",", 
        \(2\ u + diff[v\^3, u]\)}], "}"}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "But notice that ",
  StyleBox["diff",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " does not know what to do with a constant times ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", or just a constant for that matter, and we have no obvious way as yet to \
teach it what to do."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({diff[3, x], diff[3\ x, x]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({diff[3, x], diff[3\ x, x]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["We could try the following: first, give a rule for products.", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(diff[a_\ b_, x] := a\ diff[b, x] + b\ diff[a, x]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Using this for ",
  Cell[BoxData[
      \(TraditionalForm\`a\ x\)]],
  " gives"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(diff[a\ x, x]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(a + x\ diff[a, x]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The program does not know that ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " is supposed to be a constant, so we have to tell it that explicitly, with \
a last rule."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(diff[a, x] = 0; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["Then it gives the \"correct\" answer.", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(diff[a\ x, x]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(a\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "However, this is not very satisfactory. We would like some general way to \
say that ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " is not a function of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Section 1.2.5 below will continue this discussion."
}], "Text",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.2.4.2 Patterns in Local Rules", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "We will encounter this type of application quite often in the following \
chapters. In the following example, we show how to change the appearance of a \
matrix. Using ",
  StyleBox["Array",
    FontWeight->"Bold"],
  " to make a matrix with indexed entries, we then use a local rule to \
display the indices as subscripts."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(Array[x, {3, 5}] /. x[i__] -> x\_i // MatrixForm\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(x\_\(1, 1\)\), \(x\_\(1, 2\)\), \(x\_\(1, 3\)\), 
              \(x\_\(1, 4\)\), \(x\_\(1, 5\)\)},
            {\(x\_\(2, 1\)\), \(x\_\(2, 2\)\), \(x\_\(2, 3\)\), 
              \(x\_\(2, 4\)\), \(x\_\(2, 5\)\)},
            {\(x\_\(3, 1\)\), \(x\_\(3, 2\)\), \(x\_\(3, 3\)\), 
              \(x\_\(3, 4\)\), \(x\_\(3, 5\)\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "where the two consecutive underscores next to ",
  Cell[BoxData[
      \(TraditionalForm\`i\)]],
  " on the left-hand side of the rule represent one or more arguments."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
We can also use pattern matching to replace the coefficients of various terms \
any way we want. For example,\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Clear[f]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"eq1", "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              SuperscriptBox["u", "\[DoublePrime]",
                MultilineFunction->None], "[", "t", "]"}], "+", 
            RowBox[{\(u[t]\), " ", 
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", \(x\_0\), "]"}]}], "+", 
            RowBox[{\(1\/2\), " ", \(u[t]\^2\), " ", 
              RowBox[{
                SuperscriptBox["f", "\[DoublePrime]",
                  MultilineFunction->None], "[", \(x\_0\), "]"}]}], "+", 
            RowBox[{\(1\/6\), " ", \(u[t]\^3\), " ", 
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((3)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x\_0\), "]"}]}]}], "==", 
          "0"}]}], ";"}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq2 = eq1 /. _. \ u[t]^b_.  -> k\_b\ u[t]^b\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(k\_1\ u[t]\), "+", \(k\_2\ u[t]\^2\), "+", \(k\_3\ u[t]\^3\), "+", 
        RowBox[{
          SuperscriptBox["u", "\[DoublePrime]",
            MultilineFunction->None], "[", "t", "]"}]}], "==", "0"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Sometimes we may obtain, in a bifurcation analysis, a data set, which \
includes a set of bifurcation points ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  " and the corresponding control parameters ",
  Cell[BoxData[
      FormBox[
        StyleBox["cpSearch",
          FontSlant->"Italic"], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["cpFix",
          FontSlant->"Italic"], TraditionalForm]]],
  ", such as ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
              \(x\_1\), ",", \(x\_2\), ",", \(x\_3\), ",", \(x\_4\), ",", 
                StyleBox["cpSearch",
                  FontSlant->"Italic"]}], "}"}], ",", 
            StyleBox["cpFix",
              FontSlant->"Italic"]}], "}"}], TraditionalForm]]],
  ". If we want to switch these two parameters and then use the same data \
format as our initial input to a program, we have at least two choices. \
First, we take apart the data list and then assemble them:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(data1 = {{x\_1, x\_2, x\_3, x\_4, cp1}, cp2}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({Append[Drop[data1[\([1]\)], \(-1\)], data1[\([2]\)]], 
      data1[\([1, \(-1\)]\)]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{x\_1, x\_2, x\_3, x\_4, cp2}, cp1}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Second, we simply apply a local rule using patterns to the data list as a \
whole:\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(data1 /. {{a__, b_}, c_} -> {{a, c}, b}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{x\_1, x\_2, x\_3, x\_4, cp2}, cp1}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.2.5 Restricting Pattern Matching with Predicates", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "So far, all of the rules we have considered have been \"context free\" \
rewrite rules. Whenever the pattern is matched, the rewriting is carried out. \
There can be a restriction on the head of the matching expression included in \
the pattern. However, there are also ",
  StyleBox["conditional rewrite rules",
    FontColor->RGBColor[1, 0, 0]],
  ", which are only applied when some condition is satisfied. First, we have \
to discuss ",
  StyleBox["predicates",
    FontColor->RGBColor[0, 0, 1]],
  " (functions that return the value ",
  StyleBox["True",
    FontWeight->"Bold"],
  " or ",
  StyleBox["False",
    FontWeight->"Bold"],
  ") in ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "because all of the conditions will always be expressed in terms of them. \
All built-in predicates that are defined for all expressions end with ",
  StyleBox["Q",
    FontWeight->"Bold"],
  ". It is easy to display all of them."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?*Q\)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
ArgumentCountQ       LinkConnectedQ       OrderedQ
AtomQ                LinkReadyQ           PartitionsQ
DigitQ               ListQ                PolynomialQ
EllipticNomeQ        LowerCaseQ           PrimeQ
EvenQ                MachineNumberQ       SameQ
ExactNumberQ         MatchLocalNameQ      StringMatchQ
FreeQ                MatchQ               StringQ
HypergeometricPFQ    MatrixQ              SyntaxQ
InexactNumberQ       MemberQ              TrueQ
IntegerQ             NameQ                UnsameQ
IntervalMemberQ      NumberQ              UpperCaseQ
InverseEllipticNomeQ NumericQ             ValueQ
LegendreQ            OddQ                 VectorQ
LetterQ              OptionQ\
\>", "Print",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Specifically requesting information on our function gives the usage \
message.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?OddQ\)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \("OddQ[expr] gives True if expr is an odd integer, and False otherwise."\
\)], "Print",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Predicates are used to control pattern matching. In general, they are \
applied using ",
  Cell[BoxData[
      \(TraditionalForm\` /; \)]],
  " , which is the infix form of ",
  StyleBox["Condition",
    FontWeight->"Bold"],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[Hold[x /; y]]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    TagBox[
      StyleBox[\(Hold[Condition[x, y]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True],
      FullForm]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
However, the position of the predicate in an expression allows it to be used \
in different ways. If the predicate is placed at the end of a global rule \
definition, it will restrict the application of the rule. For instance, we \
can use predicates to extend our definition of differentiation in Section \
1.2.4.1 to deal with arbitrary polynomials in a very natural way by adding a \
single conditional rule.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Clear[diff]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(diff[x_^n_. , x_] := n\ x^\((n - 1)\); \n
    diff[a_ + b_, x_] := diff[a, x] + diff[b, x]; \n
    diff[a_\ b_, x_] := a\ diff[b, x] + b\ diff[a, x]; \n
    diff[a_, x_] := 0 /; FreeQ[a, x]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["Now constants and products are handled properly", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(diff[a[x] + b\ x^2 + c, x]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(2\ b\ x + diff[a[x], x]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Using ",
  StyleBox["rule",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\` /; \)],
    FontWeight->"Bold"],
  StyleBox["Predicate",
    FontWeight->"Bold"],
  " restricts the rule to those situations in which the predicate evaluates \
to ",
  StyleBox["True",
    FontWeight->"Bold"],
  ";  that is, to those expressions belonging to the type given by the \
predicate. An unrestricted rule is the same as a conditional rule where the \
predicate always equals ",
  StyleBox["True",
    FontWeight->"Bold"],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
If a predicate is immediately applied after a pattern, it will restrict the \
pattern matching rather than the rule application. For instance,\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(fac1[1] = 1; fac1[n_] := n\ fac1[n - 1]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell["\<\
This will work perfectly well if positive integers are given as arguments.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(fac1[5]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(120\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
However, if another argument is given, then it will fail badly.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\({fac1[\(-3\)], fac1[endless]}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \($RecursionLimit::"reclim" \( : \ \) 
      "Recursion depth of \!\(256\) exceeded."\)], "Message",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \($RecursionLimit::"reclim" \( : \ \) 
      "Recursion depth of \!\(256\) exceeded."\)], "Message",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \($RecursionLimit::"reclim" \( : \ \) 
      "Recursion depth of \!\(256\) exceeded."\)], "Message",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(General::"stop" \( : \ \) 
      "Further output of \!\($RecursionLimit :: \"reclim\"\) will be \
suppressed during this calculation."\)], "Message",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
A very large output is suppressed. What happens, of course, in these cases is \
that the value 1 is never encountered as an argument, so the function keeps \
calling itself recursively until the built-in recursion limit is reached. \
This bad behavior can be corrected by using a conditional rule.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(fac2[1] = 1; fac2[n_] := n\ fac2[n - 1] /; n > 1; \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({fac2[5], fac2[\(-2\)], fac2[something]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({120, fac2[\(-2\)], fac2[something]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "One can also use the form ",
  Cell[BoxData[
      FormBox[
        RowBox[{"_", "?", 
          StyleBox["Predicate",
            FontWeight->"Bold"]}], TraditionalForm]]],
  ", which restricts the pattern to something for which the predicate \
evaluates to ",
  StyleBox["True",
    FontWeight->"Bold"],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(fac3[1] = 1; fac3[n_?Positive] := n\ fac3[n - 1]; \nfac4[1] = 1; 
    fac4[n_ /; Positive[n]] := n\ fac4[n - 1]; \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({fac3[5], fac3[\(-2\)], fac4[5], fac4[\(-2\)]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({120, fac3[\(-2\)], 120, fac4[\(-2\)]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "In ",
  Cell[BoxData[
      FormBox[
        RowBox[{"n_", "?", 
          StyleBox["Positive",
            FontWeight->"Bold"]}], TraditionalForm]]],
  ", ",
  StyleBox["Positive",
    FontWeight->"Bold"],
  " is a pure function, while in the form using ",
  Cell[BoxData[
      \(TraditionalForm\` /; \)]],
  " , the condition is the value of the predicate for the name of the \
pattern. In either case, ",
  StyleBox["Positive",
    FontWeight->"Bold"],
  " or ",
  StyleBox["Positive",
    FontWeight->"Bold"],
  "[n] is a positive test in the sense that the pattern is matched and the \
rule applied only if the test succeeds. Now try ",
  StyleBox["fac4",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " on a real number and see what happens."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(fac4[3.6]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(8.98560000000000158`\ fac4[\(-0.399999999999999911`\)]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The rule is applied until the negative value -0.4 is reached, where the \
condition fails so ",
  StyleBox["fac4",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "[-0.4] is returned in unevaluated form. Of course, the real problem is \
that we only intend the function to apply to integers. But this additional \
restriction can easily be added."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(fac5[1] = 1; fac5[n_Integer?Positive] := n\ fac5[n - 1]; \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({fac5[5], fac5[3.6], fac5[\(-2\)]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"120", ",", 
        RowBox[{"fac5", "[", 
          StyleBox["3.60000000000000008`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2], "]"}], ",", \(fac5[\(-2\)]\)}], "}"}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The predicate that appears after ",
  Cell[BoxData[
      \(TraditionalForm\` /; \)]],
  " or ",
  Cell[BoxData[
      \(TraditionalForm\`?\)]],
  " can also be a user defined expression."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(test[x_Integer?\((\((# > 2)\)\ &)\)] := x + 1\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({test[1], test[2], test[3], test[4], test[5]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({test[1], test[2], 4, 5, 6}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The form ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(?Predicate\),
          FontWeight->"Bold"], TraditionalForm]]],
  " can only be used after single slots, but the form ",
  Cell[BoxData[
      FormBox[
        StyleBox[\( /; Predicate\),
          FontWeight->"Bold"], TraditionalForm]]],
  " can be used after any pattern, simple or compound. For instance,"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(f1[a_, b_] /; EvenQ[a + b] := a^b; \n
    f1[a_, b_] /; OddQ[a + b] := a^\((\(-b\))\); \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({f1[1, 3], f1[2, 3], f1[3, 3]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({1, 1\/8, 27}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Predicates also play an important role in manipulating lists.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(Select[Range[\(-5\), 5], Positive]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({1, 2, 3, 4, 5}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cases[Range[\(-5\), 5], _?Positive]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({1, 2, 3, 4, 5}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cases[Range[\(-5\), 5], a_ /; a > 0]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({1, 2, 3, 4, 5}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "There is also another form of ",
  StyleBox["Cases",
    FontWeight->"Bold"],
  " in which an operation is applied to the entries that are selected."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cases[Range[\(-5\), 5], \((a_ /; a > 0)\) :> Sqrt[a]]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({1, \@2, \@3, 2, \@5}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The following example was the 1992 ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming competition question. The problem is to write a function \
called ",
  StyleBox["maxima",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " that starts with a list of numbers and constructs the sublist of the \
numbers bigger than all previous ones from the given list. For instance, ",
  StyleBox["maxima",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "[{3, 6, 4, 2, 8, 7, 9}]",
  StyleBox[" ",
    FontWeight->"Bold"],
  "should return {3, 6, 8, 9}. The winning entry used a pattern with a \
condition in a local rule."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(maxima[list_List] := 
      list //. {a___, x_, y_, b___} /; y <= x -> {a, x, b}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(maxima[{3, 6, 4, 2, 8, 7, 9}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({3, 6, 8, 9}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.2.6 Pure Functions", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Given an expression ",
  StyleBox["expr",
    FontSlant->"Italic"],
  " involving a variable ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", we can think of ",
  StyleBox["expr",
    FontSlant->"Italic"],
  " as describing a function with ",
  StyleBox["x",
    FontSlant->"Italic"],
  " being the argument. If we need to refer to this function by name, we can \
either define a rule for ",
  StyleBox["f",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " in the form ",
  Cell[BoxData[
      \(TraditionalForm\`\(f[x_] := \)\)]],
  " ",
  StyleBox["expr",
    FontSlant->"Italic"],
  " or use the object ",
  StyleBox["Function",
    FontWeight->"Bold"],
  "[",
  StyleBox["x, expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "]. Either ",
  StyleBox["f",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " or ",
  StyleBox["Function",
    FontWeight->"Bold"],
  "[",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["expr",
    FontSlant->"Italic"],
  "] is a name for this function, and we can use the two interchangeably. To \
apply them to an argument, we write ",
  StyleBox["f",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  "[",
  StyleBox["arg",
    FontSlant->"Italic"],
  "] in the familiar way or in the so-called pure function form ",
  StyleBox["Function",
    FontWeight->"Bold"],
  "[",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["expr",
    FontSlant->"Italic"],
  "][",
  StyleBox["arg",
    FontSlant->"Italic"],
  "]."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[{
    \(f[x_] := 1 + x^2\), 
    \(\(g = Function[x, 1 + x^2]; \)\)}], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({f[2], g[2]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({5, 5}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The name of the formal argument in a pure function does not matter. ",
  StyleBox["Function",
    FontWeight->"Bold"],
  "[",
  StyleBox["x, x^2",
    FontSlant->"Italic"],
  "] is the same function as ",
  StyleBox["Function",
    FontWeight->"Bold"],
  "[",
  StyleBox["y, y^2",
    FontSlant->"Italic"],
  "]. This fact is easy to see if you apply such a function to an argument, \
the result is the same in both cases."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({\(Function[x, x^2]\)[a], \(Function[y, y^2]\)[a], Sin[a]}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({a\^2, a\^2, Sin[a]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Note that ",
  StyleBox["Sin ",
    FontWeight->"Bold"],
  "and all built-in functions, with no arguments, are pure functions. Because \
the names of the variables in a pure function do not matter, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " denotes these variables with symbols. The symbols #1, #2, ... are used \
for the first, second, ... variable. The internal form of #i is ",
  StyleBox["Slot",
    FontWeight->"Bold"],
  "[i]. If we use these forms, then we do not give the arguments of ",
  StyleBox["Function",
    FontWeight->"Bold"],
  "[ ] in order to declare the names of the variables. Thus, instead of ",
  StyleBox["Function",
    FontWeight->"Bold"],
  "[",
  StyleBox["x, x^2",
    FontSlant->"Italic"],
  "] we simply write ",
  StyleBox["Function",
    FontWeight->"Bold"],
  "[#1^2]. A convenient abbreviation for #1 is #, so we can simplify our \
example a bit more and write ",
  StyleBox["Function",
    FontWeight->"Bold"],
  "[#^2]. Finally, there is a postfix operator ",
  StyleBox["&",
    FontWeight->"Bold"],
  " for ",
  StyleBox["Function",
    FontWeight->"Bold"],
  ". That is, body",
  StyleBox["&",
    FontWeight->"Bold"],
  " is the same as ",
  StyleBox["Function",
    FontWeight->"Bold"],
  "[body]. Using this operator, we arrive at the shortest form #^2 ",
  StyleBox["&",
    FontWeight->"Bold"],
  " that our example can take. We have used this form quite frequently in \
this book. Let us see the internal form of this short form of a pure \
function."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[#^2\ &]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    TagBox[
      StyleBox[\(Function[Power[Slot[1], 2]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True],
      FullForm]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The operator ",
  StyleBox["&",
    FontWeight->"Bold"],
  " has a very low priority, just above assignment. Therefore, ",
  Cell[BoxData[
      \(TraditionalForm\`\(x = \)\)]],
  " body ",
  StyleBox["&",
    FontWeight->"Bold"],
  " is understood as ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(x = \)\ \)\)]],
  StyleBox["Function",
    FontWeight->"Bold"],
  "[body], but ",
  Cell[BoxData[
      \(TraditionalForm\`\(x -> \)\)]],
  " body ",
  StyleBox["&",
    FontWeight->"Bold"],
  " is interpreted as ",
  StyleBox["Function",
    FontWeight->"Bold"],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`\(x -> \)\)]],
  " body]. If we want the right-hand side of the rule to be the pure \
function, we use ",
  Cell[BoxData[
      \(TraditionalForm\`\(x -> \)\)]],
  " (body ",
  StyleBox["&",
    FontWeight->"Bold"],
  "). Beware of ",
  Cell[BoxData[
      \(TraditionalForm\`\(x -> \)\)]],
  " (body) ",
  StyleBox["&",
    FontWeight->"Bold"],
  ". Another case where the low priority of pure functions requires the use \
of parentheses is in predicates for patterns: x_?body",
  StyleBox["&",
    FontWeight->"Bold"],
  " is not the same as x_?(body",
  StyleBox["&",
    FontWeight->"Bold"],
  "). The latter is usually correct."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(1 + # + #^2\ &\)\ [3]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(13\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The whole expression to the left of ",
  StyleBox["&",
    FontWeight->"Bold"],
  " is part of the body of the pure function. No parentheses are necessary. \
In other situations, parentheses are necessary."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(h[a] /. h -> \((#^2\ &)\)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(a\^2\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Parentheses around the pure function are needed here; otherwise, the whole \
rule would be considered a part of the body of the function.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "Pure functions written in the form with ",
  Cell[BoxData[
      \(TraditionalForm\`#\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`&\)]],
  " are very concise and useful, especially, in functional operations, such \
as ",
  StyleBox["Map",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Apply",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Thread",
    FontWeight->"Bold"],
  ", and iteration functions, such as ",
  StyleBox["FoldList",
    FontWeight->"Bold"],
  ". For example,"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq1 = \[PartialD]\_\(t, t\)u[x, t]/a + u[x, t] == F[x]/a\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{\(u[x, t]\), "+", 
        FractionBox[
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((0, 2)\),
                Derivative],
              MultilineFunction->None], "[", \(x, t\), "]"}], "a"]}], "==", 
      \(F[x]\/a\)}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[BoxData[
    \(Clear[lhs2]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(eq2 = lhs2 == rhs2; \neq3 = lhs3 == rhs3; \)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "We can multiply both sides of ",
  StyleBox["eq1",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " by ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " and use ",
  StyleBox["Thread",
    FontWeight->"Bold"],
  " and obtain"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(eq1 // Thread[a  #, Equal]\ &\) // ExpandAll\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{\(a\ u[x, t]\), "+", 
        RowBox[{
          SuperscriptBox["u", 
            TagBox[\((0, 2)\),
              Derivative],
            MultilineFunction->None], "[", \(x, t\), "]"}]}], "==", 
      \(F[x]\)}]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Moreover, we can add ",
  StyleBox["eq2",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " to ",
  StyleBox["eq3",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " by"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(eq2 + eq3 // Thread[#, Equal]\ &\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(lhs2 + lhs3 == rhs2 + rhs3\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.2.7 Map and Apply", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", two important commands that take functions as arguments are ",
  StyleBox["Map",
    FontWeight->"Bold"],
  "[ ] and ",
  StyleBox["Apply",
    FontWeight->"Bold"],
  "[ ]. The various versions of ",
  StyleBox["Map",
    FontWeight->"Bold"],
  " act on the arguments of an expression, while ",
  StyleBox["Apply",
    FontWeight->"Bold"],
  " acts only on its head."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell["1.2.7.1 Mapping Functions onto Expressions", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The operation ",
  StyleBox["Map",
    FontWeight->"Bold"],
  "[",
  StyleBox["f",
    FontSlant->"Italic"],
  ", ",
  StyleBox["list",
    FontSlant->"Italic"],
  "] or in infix form ",
  Cell[BoxData[
      FormBox[
        RowBox[{"f", " ", "/@", " ", 
          StyleBox["list",
            FontSlant->"Italic"]}], TraditionalForm]]],
  " applies the function  ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  to each element of the list ",
  StyleBox["list",
    FontSlant->"Italic"],
  ". The second argument of ",
  StyleBox["Map",
    FontWeight->"Bold"],
  "[ ] need not be a list, however. Any expression of the form ",
  StyleBox["h",
    FontSlant->"Italic"],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`e\_1, e\_2,  ... , e\_n\)]],
  "] will do. The result of the mapping is the expression ",
  Cell[BoxData[
      \(TraditionalForm\`h[f[e\_1], f[e\_2],  ... , f[e\_n]]\)]],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(Clear[f]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({Map[f, a + b + c], \(#^2\ &\)\ /@\ {1, 2, 3}}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({f[a] + f[b] + f[c], {1, 4, 9}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  StyleBox["Map",
    FontWeight->"Bold"],
  "[",
  StyleBox["f",
    FontSlant->"Italic"],
  ", ",
  StyleBox["expr",
    FontSlant->"Italic"],
  ", ",
  StyleBox["levelspec",
    FontSlant->"Italic"],
  "] has an optional third argument that specifies the levels at which to \
map. The default level is {1};  that is, at the elements of ",
  StyleBox["expr",
    FontSlant->"Italic"],
  ". In a matrix, the entries are at level 2 (there are two levels of lists). \
If we want to map a function at these entries, we can use ",
  StyleBox["Map",
    FontWeight->"Bold"],
  "[",
  StyleBox["f",
    FontSlant->"Italic"],
  ", ",
  StyleBox["matrix",
    FontSlant->"Italic"],
  ", {2}]."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(expr1 = {{a\_\(1, 1\), a\_\(1, 2\)}, {a\_\(2, 1\), a\_\(2, 2\)}}; 
    \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[entry, expr1, {2}] // MatrixForm\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(entry[a\_\(1, 1\)]\), \(entry[a\_\(1, 2\)]\)},
            {\(entry[a\_\(2, 1\)]\), \(entry[a\_\(2, 2\)]\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "This is a very powerful facility and is one of our main tools in \
manipulating expressions. The purpose of the operations based on ",
  StyleBox["Map",
    FontWeight->"Bold"],
  " is to make it possible to treat lists as wholes. For instance, a really \
poor way to square the entries in a list is as follows:"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(list1 = {a, b, c}; \nTable[list1[\([i]\)]^2, {i, Length[list1]}]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({a\^2, b\^2, c\^2}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The term ",
  StyleBox["list1[[i]]",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " tears apart the original list by extracting its parts one at a time, ",
  Cell[BoxData[
      \(TraditionalForm\`\(^2\)\)]],
  " squares each part, and then ",
  StyleBox["Table",
    FontWeight->"Bold"],
  " reassembles the parts into a new list. ",
  StyleBox["Map",
    FontWeight->"Bold"],
  ", however, allows us to treat mathematical structures as wholes so that we \
do not tear them apart and rebuild them again."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  StyleBox["Map",
    FontWeight->"Bold"],
  "[ ] always maps the function at all elements of the given levels. The \
command ",
  StyleBox["MapAt",
    FontWeight->"Bold"],
  "[",
  StyleBox["f",
    FontSlant->"Italic"],
  ", ",
  StyleBox["expr",
    FontSlant->"Italic"],
  ", ",
  StyleBox["poslist",
    FontSlant->"Italic"],
  "] allows you to apply a function at selective positions."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(MapAt[G, a\ b + c\ d + e\ f, {2, 1}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(a\ b + e\ f + d\ G[c]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(expr2 = a + b/a + c\ Exp[a + 1]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(a + b\/a + c\ E\^\(1 + a\)\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "If we want to map a function ",
  StyleBox["f",
    FontSlant->"Italic"],
  " at all occurrences of ",
  StyleBox["a",
    FontSlant->"Italic"],
  ", we first find all the positions of ",
  StyleBox["a",
    FontSlant->"Italic"],
  " in our expression."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(Position[expr2, a]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{1}, {2, 1, 1}, {3, 2, 2, 2}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "This list of positions is in the right form for ",
  StyleBox["MapAt",
    FontWeight->"Bold"],
  " and can be used directly."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(MapAt[f, expr2, %]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(c\ E\^\(1 + f[a]\) + b\/f[a] + f[a]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
This particular example could have been done more easily with a replacement \
rule.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(expr2 /. a -> f[a]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(c\ E\^\(1 + f[a]\) + b\/f[a] + f[a]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "In some applications, the function to be performed on an element ",
  Cell[BoxData[
      \(TraditionalForm\`e\_i\)]],
  " may depend on its position ",
  StyleBox["i",
    FontSlant->"Italic"],
  ". The operation ",
  StyleBox["MapIndexed",
    FontWeight->"Bold"],
  "[",
  StyleBox["f",
    FontSlant->"Italic"],
  ", {",
  Cell[BoxData[
      \(TraditionalForm\`e\_1, e\_2,  ... , e\_n\)]],
  "}] behaves essentially like ",
  StyleBox["Map",
    FontWeight->"Bold"],
  "[ ], but it passes the position of each element as a second argument to ",
  StyleBox["f",
    FontSlant->"Italic"],
  ". The resulting expression is"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(MapIndexed[1 + #^2\ &, {a, b, c, d}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({1 + a\^2, 1 + b\^2, 1 + c\^2, 1 + d\^2}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MapIndexed[1 + #^2\ &, {{a, b}, {c, d}}, {2}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{1 + a\^2, 1 + b\^2}, {1 + c\^2, 1 + d\^2}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
Therefore, the function that is mapped must be a function of two arguments. \
The second argument is a position (note the list braces) that can be used to \
modify the operation performed on the first argument.\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(MapIndexed[#1^First[#2]\ &, {a, b, c, d, e}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({a, b\^2, c\^3, d\^4, e\^5}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.2.7.2 Apply", "Subsubsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "The rule ",
  StyleBox["Apply",
    FontWeight->"Bold"],
  "[",
  StyleBox["h",
    FontSlant->"Italic"],
  ", ",
  StyleBox["expr",
    FontSlant->"Italic"],
  "] or ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["h",
            FontSlant->"Italic"], " ", "@@", " ", 
          StyleBox["expr",
            FontSlant->"Italic"]}], TraditionalForm]]],
  " replaces the head of ",
  StyleBox["expr",
    FontSlant->"Italic"],
  " by ",
  StyleBox["h.",
    FontSlant->"Italic"]
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(a + b + c // FullForm\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    TagBox[
      StyleBox[\(Plus[a, b, c]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True],
      FullForm]], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Replacing the head ",
  StyleBox["Plus",
    FontWeight->"Bold"],
  " by ",
  StyleBox["Times",
    FontWeight->"Bold"],
  " gives the product of the three terms in the sum above."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({Apply[Times, a + b + c], Times\ @@\ \((a + b + c)\)}\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({a\ b\ c, a\ b\ c}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "With a third argument, ",
  StyleBox["Apply",
    FontWeight->"Bold"],
  "[",
  StyleBox["h",
    FontSlant->"Italic"],
  ", ",
  StyleBox["expr",
    FontSlant->"Italic"],
  ", ",
  StyleBox["levelspec",
    FontSlant->"Italic"],
  "] replaces heads in the parts of ",
  StyleBox["expr",
    FontSlant->"Italic"],
  " described by ",
  StyleBox["levelspec",
    FontSlant->"Italic"],
  " by ",
  StyleBox["h",
    FontSlant->"Italic"],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[b, {{a[1, 1], a[1, 2]}, {a[2, 1], a[2, 2]}}, {2}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({{b[1, 1], b[1, 2]}, {b[2, 1], b[2, 2]}}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["\<\
This simple definition finds the average of a list of numbers\
\>", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[{
    \(average[list1_List] := Apply[Plus, list1]/Length[list1]\), 
    \(average[{a, b, c}]\)}], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(1\/3\ \((a + b + c)\)\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Note that computing the average of a list in this way requires no do-loops \
or knowledge of the length of the list. ",
  StyleBox["Apply",
    FontWeight->"Bold"],
  " is frequently used if one first wants to prepare a number of ingredients \
and then apply some operation to them. The ingredients can be held in a list \
until they are ready and then the head of the list is changed to the \
appropriate operation by using ",
  StyleBox["Apply",
    FontWeight->"Bold"],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  "To generate more concise notations for the outputs created in the \
following chapters, we can introduce ",
  StyleBox["displayRule",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 1]],
  " to meet our needs. For example,"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{"output", "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              SubsuperscriptBox["u", "2", 
                TagBox[\((2, 0, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(T\_0, T\_1, T\_2\), "]"}], 
            "+", \(\[Omega]\^2\ u\_2[T\_0, T\_1, T\_2]\)}], "==", 
          RowBox[{
            RowBox[{"2", " ", 
              RowBox[{
                SubsuperscriptBox["u", "1", 
                  TagBox[\((1, 1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(T\_0, T\_1, T\_2\), 
                "]"}]}], "-", \(\[Delta]\ u\_1[T\_0, T\_1, T\_2]\^2\)}]}]}], 
      ";"}]], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\(displayRule = {
        \(\(Derivative[a__]\)[u\_i_]\)[__] :> 
          SequenceForm[
            Times\ @@\ MapIndexed[D\_\(#2[\([1]\)] - 1\)\%#1\ &, {a}], u\_i], 
        u\_i_[__] -> u\_i}; \)\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(output /. displayRule\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    RowBox[{
      RowBox[{
        InterpretationBox[\(D\_0\%2\[InvisibleSpace]u\_2\),
          SequenceForm[ 
            Power[ 
              Subscript[ D, 0], 2], 
            Subscript[ u, 2]],
          Editable->False], "+", \(\[Omega]\^2\ u\_2\)}], "==", 
      RowBox[{
        RowBox[{"2", " ", 
          RowBox[{"(", 
            InterpretationBox[\(\(D\_0\ D\_1\)\[InvisibleSpace]u\_1\),
              SequenceForm[ 
                Times[ 
                  Subscript[ D, 0], 
                  Subscript[ D, 1]], 
                Subscript[ u, 1]],
              Editable->False], ")"}]}], "-", \(\[Delta]\ u\_1\%2\)}]}]], 
  "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.2.8 Nest and Fold", "Subsection",
  TextAlignment->Left,
  TextJustification->1],

Cell[TextData[{
  StyleBox["Nest",
    FontWeight->"Bold"],
  " and its related operations ",
  StyleBox["NestList",
    FontWeight->"Bold"],
  " and ",
  StyleBox["FixedPoint",
    FontWeight->"Bold"],
  " apply a function to its argument many times. ",
  StyleBox["Nest",
    FontWeight->"Bold"],
  "[",
  StyleBox["function",
    FontSlant->"Italic"],
  ", ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["n",
    FontSlant->"Italic"],
  "] applies ",
  StyleBox["function",
    FontSlant->"Italic"],
  " to ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and repeats the application ",
  StyleBox["n",
    FontSlant->"Italic"],
  " times"
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(Nest[\((1 + #)\)\^2&, x, 3]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(\((1 + \((1 + \((1 + x)\)\^2)\)\^2)\)\^2\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NestList[\((1 + #)\)\^2&, x, 3]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({x, \((1 + x)\)\^2, \((1 + \((1 + x)\)\^2)\)\^2, 
      \((1 + \((1 + \((1 + x)\)\^2)\)\^2)\)\^2}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell["Here is an example producing a simple continued fraction.", "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(Nest[1/\((1 + #)\)\ &, a, 3]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(1\/\(1 + 1\/\(1 + 1\/\(1 + a\)\)\)\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "An operation that is closely related to ",
  StyleBox["Nest",
    FontWeight->"Bold"],
  " is ",
  StyleBox["FixedPoint",
    FontWeight->"Bold"],
  ", which nests its operation until there is no change. For instance, \
everyone is familiar with what happens if the ",
  StyleBox["Cos",
    FontWeight->"Bold"],
  " key on a pocket calculator is pushed repeatedly. In principle, ",
  StyleBox["FixedPoint",
    FontWeight->"Bold"],
  " is what happens if it is pushed forever."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \({Nest[Cos, 0.3, 5], Nest[Cos, 0.3, 10], FixedPoint[Cos, 0.3]}\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({0.784436224742356191`, 0.732698207891766895`, 0.739085133215160539`}
      \)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "Actually, ",
  StyleBox["FixedPoint",
    FontWeight->"Bold"],
  " stops after machine accuracy is achieved. We can use the option ",
  StyleBox["SameTest",
    FontWeight->"Bold"],
  " to get some control of ",
  StyleBox["FixedPoint",
    FontWeight->"Bold"],
  "."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(FixedPoint[Cos, 0.3, SameTest -> \((Abs[#1 - #2] < 10^\(-5\)\ &)\)]\)], 
  "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(0.739088633914084347`\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[TextData[{
  "The second pair of functions, ",
  StyleBox["Fold",
    FontWeight->"Bold"],
  " and ",
  StyleBox["FoldList",
    FontWeight->"Bold"],
  ", do something similar to ",
  StyleBox["Nest",
    FontWeight->"Bold"],
  " and ",
  StyleBox["NestList",
    FontWeight->"Bold"],
  ", but for functions of two variables."
}], "Text",
  TextAlignment->Left,
  TextJustification->1],

Cell[CellGroupData[{

Cell[BoxData[
    \(Fold[f, u, {x, y, z}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \(f[f[f[u, x], y], z]\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FoldList[f, u, {x, y, z}]\)], "Input",
  TextAlignment->Left,
  TextJustification->1],

Cell[BoxData[
    \({u, f[u, x], f[f[u, x], y], f[f[f[u, x], y], z]}\)], "Output",
  TextAlignment->Left,
  TextJustification->1]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 712}},
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{726, 608},
WindowMargins->{{2, Automatic}, {Automatic, 5}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PrintingOptions->{"FirstPageHeader"->False,
"FacingPages"->True},
PrivateFontOptions->{"FontType"->"Outline"},
StyleDefinitions -> "Default.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "ChapterOne"->{
    Cell[2074, 69, 307, 7, 52, "Section",
      Evaluatable->False,
      CellTags->{"ChapterOne", "ChapterOne.1"}],
    Cell[7091, 183, 308, 7, 32, "Section",
      Evaluatable->False,
      CellTags->{"ChapterOne", "ChapterOne.1"}]},
  "ChapterOne.1"->{
    Cell[2074, 69, 307, 7, 52, "Section",
      Evaluatable->False,
      CellTags->{"ChapterOne", "ChapterOne.1"}],
    Cell[7091, 183, 308, 7, 32, "Section",
      Evaluatable->False,
      CellTags->{"ChapterOne", "ChapterOne.1"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"ChapterOne", 185250, 6295},
  {"ChapterOne.1", 185506, 6302}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 94, 5, 148, "Title"],
Cell[1828, 58, 118, 2, 32, "Text"],
Cell[1949, 62, 100, 3, 30, "Input"],

Cell[CellGroupData[{
Cell[2074, 69, 307, 7, 52, "Section",
  Evaluatable->False,
  CellTags->{"ChapterOne", "ChapterOne.1"}],
Cell[2384, 78, 1427, 26, 176, "Text"],
Cell[3814, 106, 636, 19, 68, "Text"],
Cell[4453, 127, 759, 13, 104, "Text"],
Cell[5215, 142, 744, 12, 104, "Text"],
Cell[5962, 156, 696, 12, 104, "Text"],
Cell[6661, 170, 393, 8, 68, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[7091, 183, 308, 7, 32, "Section",
  Evaluatable->False,
  CellTags->{"ChapterOne", "ChapterOne.1"}],
Cell[7402, 192, 911, 20, 104, "Text"],
Cell[8316, 214, 820, 23, 102, "Text"],
Cell[9139, 239, 614, 25, 50, "Text"],

Cell[CellGroupData[{
Cell[9778, 268, 87, 2, 46, "Subsection"],
Cell[9868, 272, 1574, 45, 104, "Text"],

Cell[CellGroupData[{
Cell[11467, 321, 160, 7, 42, "Subsubsection"],
Cell[11630, 330, 641, 16, 68, "Text"],
Cell[12274, 348, 91, 3, 30, "Input"],
Cell[12368, 353, 372, 12, 50, "Text"],

Cell[CellGroupData[{
Cell[12765, 369, 109, 3, 30, "Input"],
Cell[12877, 374, 91, 3, 29, "Output"]
}, Open  ]],
Cell[12983, 380, 206, 8, 32, "Text"],
Cell[13192, 390, 91, 3, 30, "Input"],

Cell[CellGroupData[{
Cell[13308, 397, 85, 3, 30, "Input"],
Cell[13396, 402, 91, 3, 29, "Output"]
}, Open  ]],
Cell[13502, 408, 285, 12, 32, "Text"],
Cell[13790, 422, 262, 11, 32, "Text"],
Cell[14055, 435, 85, 3, 30, "Input"],
Cell[14143, 440, 187, 8, 32, "Text"],

Cell[CellGroupData[{
Cell[14355, 452, 85, 3, 30, "Input"],
Cell[14443, 457, 91, 3, 29, "Output"]
}, Open  ]],
Cell[14549, 463, 199, 8, 32, "Text"],
Cell[14751, 473, 970, 35, 50, "Text"],

Cell[CellGroupData[{
Cell[15746, 512, 119, 3, 30, "Input"],
Cell[15868, 517, 102, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16007, 525, 92, 3, 30, "Input"],
Cell[16102, 530, 91, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16230, 538, 92, 3, 30, "Input"],
Cell[16325, 543, 91, 3, 29, "Output"]
}, Open  ]],
Cell[16431, 549, 299, 6, 50, "Text"],

Cell[CellGroupData[{
Cell[16755, 559, 122, 3, 30, "Input"],
Cell[16880, 564, 100, 3, 29, "Output"]
}, Open  ]],
Cell[16995, 570, 694, 24, 50, "Text"],

Cell[CellGroupData[{
Cell[17714, 598, 114, 3, 30, "Input"],
Cell[17831, 603, 114, 3, 29, "Output"]
}, Open  ]],
Cell[17960, 609, 884, 29, 50, "Text"],

Cell[CellGroupData[{
Cell[18869, 642, 89, 3, 30, "Input"],
Cell[18961, 647, 93, 3, 25, "Print"],
Cell[19057, 652, 325, 10, 25, "Print"]
}, Open  ]],
Cell[19397, 665, 119, 2, 32, "Text"],
Cell[19519, 669, 206, 5, 32, "Text"],

Cell[CellGroupData[{
Cell[19750, 678, 89, 3, 30, "Input"],
Cell[19842, 683, 157, 4, 25, "Message"],
Cell[20002, 689, 82, 3, 29, "Output"]
}, Open  ]],
Cell[20099, 695, 1356, 44, 104, "Text"],
Cell[21458, 741, 127, 3, 70, "Input"],
Cell[21588, 746, 289, 13, 32, "Text"],

Cell[CellGroupData[{
Cell[21902, 763, 93, 3, 30, "Input"],
Cell[21998, 768, 90, 3, 29, "Output"]
}, Open  ]],
Cell[22103, 774, 400, 12, 50, "Text"],

Cell[CellGroupData[{
Cell[22528, 790, 90, 3, 30, "Input"],
Cell[22621, 795, 82, 3, 29, "Output"]
}, Open  ]],
Cell[22718, 801, 376, 16, 32, "Text"],

Cell[CellGroupData[{
Cell[23119, 821, 86, 3, 30, "Input"],
Cell[23208, 826, 90, 3, 25, "Print"],
Cell[23301, 831, 292, 10, 25, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23630, 846, 89, 3, 30, "Input"],
Cell[23722, 851, 86, 3, 29, "Output"]
}, Open  ]],
Cell[23823, 857, 277, 8, 32, "Text"],
Cell[24103, 867, 107, 3, 30, "Input"],
Cell[24213, 872, 204, 8, 32, "Text"],

Cell[CellGroupData[{
Cell[24442, 884, 86, 3, 30, "Input"],
Cell[24531, 889, 90, 3, 25, "Print"],
Cell[24624, 894, 325, 10, 62, "Print"]
}, Open  ]],
Cell[24964, 907, 122, 2, 32, "Text"],

Cell[CellGroupData[{
Cell[25111, 913, 108, 3, 30, "Input"],
Cell[25222, 918, 179, 4, 29, "Output"]
}, Open  ]],
Cell[25416, 925, 210, 7, 32, "Text"],
Cell[25629, 934, 99, 3, 30, "Input"],
Cell[25731, 939, 193, 7, 32, "Text"],

Cell[CellGroupData[{
Cell[25949, 950, 98, 3, 30, "Input"],
Cell[26050, 955, 101, 3, 29, "Output"]
}, Open  ]],
Cell[26166, 961, 463, 16, 50, "Text"],

Cell[CellGroupData[{
Cell[26654, 981, 92, 3, 30, "Input"],
Cell[26749, 986, 215, 7, 29, "Output"]
}, Open  ]],
Cell[26979, 996, 71, 2, 32, "Text"],

Cell[CellGroupData[{
Cell[27075, 1002, 94, 3, 30, "Input"],
Cell[27172, 1007, 215, 7, 29, "Output"]
}, Open  ]],
Cell[27402, 1017, 682, 21, 68, "Text"],
Cell[28087, 1040, 100, 3, 30, "Input"],
Cell[28190, 1045, 188, 8, 32, "Text"],

Cell[CellGroupData[{
Cell[28403, 1057, 108, 3, 30, "Input"],
Cell[28514, 1062, 117, 3, 29, "Output"]
}, Open  ]],
Cell[28646, 1068, 180, 7, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28863, 1080, 161, 7, 42, "Subsubsection"],
Cell[29027, 1089, 539, 16, 68, "Text"],
Cell[29569, 1107, 160, 4, 70, "Input"],
Cell[29732, 1113, 113, 2, 32, "Text"],

Cell[CellGroupData[{
Cell[29870, 1119, 92, 3, 30, "Input"],
Cell[29965, 1124, 115, 3, 29, "Output"]
}, Open  ]],
Cell[30095, 1130, 378, 15, 32, "Text"],
Cell[30476, 1147, 95, 3, 30, "Input"],

Cell[CellGroupData[{
Cell[30596, 1154, 92, 3, 30, "Input"],
Cell[30691, 1159, 166, 4, 29, "Output"]
}, Open  ]],
Cell[30872, 1166, 611, 12, 86, "Text"],

Cell[CellGroupData[{
Cell[31508, 1182, 99, 3, 30, "Input"],
Cell[31610, 1187, 85, 3, 29, "Output"]
}, Open  ]],
Cell[31710, 1193, 100, 3, 30, "Input"],
Cell[31813, 1198, 446, 14, 50, "Text"],

Cell[CellGroupData[{
Cell[32284, 1216, 100, 3, 30, "Input"],
Cell[32387, 1221, 120, 3, 29, "Output"]
}, Open  ]],
Cell[32522, 1227, 1378, 46, 104, "Text"],

Cell[CellGroupData[{
Cell[33925, 1277, 100, 3, 30, "Input"],
Cell[34028, 1282, 198, 7, 29, "Output"]
}, Open  ]],
Cell[34241, 1292, 293, 10, 32, "Text"],

Cell[CellGroupData[{
Cell[34559, 1306, 106, 3, 30, "Input"],
Cell[34668, 1311, 239, 7, 29, "Output"]
}, Open  ]],
Cell[34922, 1321, 478, 16, 50, "Text"],
Cell[35403, 1339, 380, 9, 50, "Text"],
Cell[35786, 1350, 96, 3, 30, "Input"],

Cell[CellGroupData[{
Cell[35907, 1357, 106, 3, 30, "Input"],
Cell[36016, 1362, 596, 18, 29, "Output"]
}, Open  ]],
Cell[36627, 1383, 386, 14, 32, "Text"],
Cell[37016, 1399, 118, 3, 30, "Input"],
Cell[37137, 1404, 189, 7, 32, "Text"],

Cell[CellGroupData[{
Cell[37351, 1415, 106, 3, 30, "Input"],
Cell[37460, 1420, 261, 8, 29, "Output"]
}, Open  ]],
Cell[37736, 1431, 607, 23, 32, "Text"],
Cell[38346, 1456, 237, 6, 90, "Input"],
Cell[38586, 1464, 182, 7, 32, "Text"],
Cell[38771, 1473, 105, 3, 30, "Input"],
Cell[38879, 1478, 67, 2, 32, "Text"],

Cell[CellGroupData[{
Cell[38971, 1484, 110, 3, 30, "Input"],
Cell[39084, 1489, 101, 3, 29, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[39246, 1499, 86, 2, 46, "Subsection"],
Cell[39335, 1503, 856, 34, 50, "Text"],

Cell[CellGroupData[{
Cell[40216, 1541, 161, 7, 42, "Subsubsection"],
Cell[40380, 1550, 207, 7, 32, "Text"],

Cell[CellGroupData[{
Cell[40612, 1561, 130, 3, 50, "Input"],
Cell[40745, 1566, 111, 3, 29, "Output"]
}, Open  ]],
Cell[40871, 1572, 303, 12, 32, "Text"],

Cell[CellGroupData[{
Cell[41199, 1588, 91, 3, 30, "Input"],
Cell[41293, 1593, 93, 3, 29, "Output"]
}, Open  ]],
Cell[41401, 1599, 1188, 39, 86, "Text"],

Cell[CellGroupData[{
Cell[42614, 1642, 107, 3, 30, "Input"],
Cell[42724, 1647, 86, 3, 29, "Output"]
}, Open  ]],
Cell[42825, 1653, 220, 5, 32, "Text"],

Cell[CellGroupData[{
Cell[43070, 1662, 127, 3, 30, "Input"],
Cell[43200, 1667, 94, 3, 29, "Output"]
}, Open  ]],
Cell[43309, 1673, 453, 16, 50, "Text"],

Cell[CellGroupData[{
Cell[43787, 1693, 101, 3, 30, "Input"],
Cell[43891, 1698, 92, 3, 29, "Output"]
}, Open  ]],
Cell[43998, 1704, 195, 7, 32, "Text"],

Cell[CellGroupData[{
Cell[44218, 1715, 121, 3, 30, "Input"],
Cell[44342, 1720, 108, 3, 29, "Output"]
}, Open  ]],
Cell[44465, 1726, 322, 11, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[44824, 1742, 161, 7, 42, "Subsubsection"],
Cell[44988, 1751, 331, 11, 32, "Text"],
Cell[45322, 1764, 137, 3, 30, "Input"],
Cell[45462, 1769, 88, 3, 30, "Input"],

Cell[CellGroupData[{
Cell[45575, 1776, 114, 3, 30, "Input"],
Cell[45692, 1781, 133, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[45862, 1789, 136, 3, 30, "Input"],
Cell[46001, 1794, 202, 4, 29, "Output"]
}, Open  ]],
Cell[46218, 1801, 2400, 81, 104, "Text"],
Cell[48621, 1884, 133, 4, 32, "Text"],

Cell[CellGroupData[{
Cell[48779, 1892, 107, 3, 30, "Input"],
Cell[48889, 1897, 227, 7, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49153, 1909, 107, 3, 30, "Input"],
Cell[49263, 1914, 234, 7, 29, "Output"]
}, Open  ]],
Cell[49512, 1924, 711, 31, 50, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[50260, 1960, 212, 9, 42, "Subsubsection"],
Cell[50475, 1971, 398, 14, 50, "Text"],

Cell[CellGroupData[{
Cell[50898, 1989, 120, 3, 30, "Input"],
Cell[51021, 1994, 265, 9, 29, "Output"]
}, Open  ]],
Cell[51301, 2006, 1225, 32, 122, "Text"],

Cell[CellGroupData[{
Cell[52551, 2042, 129, 3, 30, "Input"],
Cell[52683, 2047, 90, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[52810, 2055, 130, 3, 30, "Input"],
Cell[52943, 2060, 84, 3, 29, "Output"]
}, Open  ]],
Cell[53042, 2066, 1154, 37, 86, "Text"],
Cell[54199, 2105, 595, 17, 68, "Text"],

Cell[CellGroupData[{
Cell[54819, 2126, 130, 3, 30, "Input"],
Cell[54952, 2131, 82, 3, 29, "Output"]
}, Open  ]],
Cell[55049, 2137, 186, 5, 32, "Text"],

Cell[CellGroupData[{
Cell[55260, 2146, 117, 3, 30, "Input"],
Cell[55380, 2151, 90, 3, 29, "Output"]
}, Open  ]],
Cell[55485, 2157, 161, 5, 32, "Text"],

Cell[CellGroupData[{
Cell[55671, 2166, 133, 3, 30, "Input"],
Cell[55807, 2171, 90, 3, 29, "Output"]
}, Open  ]],
Cell[55912, 2177, 189, 5, 32, "Text"],

Cell[CellGroupData[{
Cell[56126, 2186, 106, 3, 30, "Input"],
Cell[56235, 2191, 87, 3, 29, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[56383, 2201, 91, 2, 46, "Subsection"],
Cell[56477, 2205, 950, 33, 68, "Text"],
Cell[57430, 2240, 91, 3, 30, "Input"],

Cell[CellGroupData[{
Cell[57546, 2247, 123, 3, 50, "Input"],
Cell[57672, 2252, 87, 3, 29, "Output"]
}, Open  ]],
Cell[57774, 2258, 243, 8, 32, "Text"],

Cell[CellGroupData[{
Cell[58042, 2270, 138, 3, 50, "Input"],
Cell[58183, 2275, 111, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[58331, 2283, 150, 4, 50, "Input"],
Cell[58484, 2289, 118, 3, 29, "Output"]
}, Open  ]],
Cell[58617, 2295, 203, 7, 32, "Text"],

Cell[CellGroupData[{
Cell[58845, 2306, 153, 4, 50, "Input"],
Cell[59001, 2312, 112, 3, 29, "Output"]
}, Open  ]],
Cell[59128, 2318, 280, 6, 50, "Text"],

Cell[CellGroupData[{
Cell[59433, 2328, 133, 3, 50, "Input"],
Cell[59569, 2333, 108, 3, 29, "Output"]
}, Open  ]],
Cell[59692, 2339, 790, 15, 104, "Text"],

Cell[CellGroupData[{
Cell[60507, 2358, 145, 4, 50, "Input"],
Cell[60655, 2364, 96, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[60788, 2372, 146, 4, 50, "Input"],
Cell[60937, 2378, 93, 3, 29, "Output"]
}, Open  ]],
Cell[61045, 2384, 360, 7, 68, "Text"],

Cell[CellGroupData[{
Cell[61430, 2395, 133, 3, 50, "Input"],
Cell[61566, 2400, 103, 3, 29, "Output"]
}, Open  ]],
Cell[61684, 2406, 1261, 44, 68, "Text"],

Cell[CellGroupData[{
Cell[62970, 2454, 146, 4, 50, "Input"],
Cell[63119, 2460, 105, 3, 29, "Output"]
}, Open  ]],
Cell[63239, 2466, 642, 17, 68, "Text"],

Cell[CellGroupData[{
Cell[63906, 2487, 138, 3, 50, "Input"],
Cell[64047, 2492, 105, 3, 29, "Output"]
}, Open  ]],
Cell[64167, 2498, 550, 14, 68, "Text"],
Cell[64720, 2514, 242, 5, 50, "Input"],

Cell[CellGroupData[{
Cell[64987, 2523, 114, 3, 30, "Input"],
Cell[65104, 2528, 26867, 708, 146, 6638, 452, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[92008, 3241, 132, 3, 30, "Input"],
Cell[92143, 3246, 38403, 853, 232, 6433, 452, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],
Cell[130561, 4102, 566, 14, 68, "Text"],

Cell[CellGroupData[{
Cell[131152, 4120, 181, 4, 50, "Input"],
Cell[131336, 4126, 345, 10, 29, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[131730, 4142, 98, 2, 46, "Subsection"],
Cell[131831, 4146, 192, 6, 32, "Text"],

Cell[CellGroupData[{
Cell[132048, 4156, 104, 2, 42, "Subsubsection"],
Cell[132155, 4160, 172, 5, 32, "Text"],
Cell[132330, 4167, 172, 4, 50, "Input"],
Cell[132505, 4173, 219, 7, 32, "Text"],

Cell[CellGroupData[{
Cell[132749, 4184, 128, 3, 30, "Input"],
Cell[132880, 4189, 329, 9, 29, "Output"]
}, Open  ]],
Cell[133224, 4201, 378, 12, 50, "Text"],

Cell[CellGroupData[{
Cell[133627, 4217, 107, 3, 30, "Input"],
Cell[133737, 4222, 108, 3, 29, "Output"]
}, Open  ]],
Cell[133860, 4228, 123, 2, 32, "Text"],
Cell[133986, 4232, 128, 3, 30, "Input"],
Cell[134117, 4237, 157, 7, 32, "Text"],

Cell[CellGroupData[{
Cell[134299, 4248, 93, 3, 30, "Input"],
Cell[134395, 4253, 98, 3, 29, "Output"]
}, Open  ]],
Cell[134508, 4259, 253, 8, 32, "Text"],
Cell[134764, 4269, 100, 3, 30, "Input"],
Cell[134867, 4274, 100, 2, 32, "Text"],

Cell[CellGroupData[{
Cell[134992, 4280, 93, 3, 30, "Input"],
Cell[135088, 4285, 82, 3, 29, "Output"]
}, Open  ]],
Cell[135185, 4291, 346, 11, 50, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[135568, 4307, 103, 2, 42, "Subsubsection"],
Cell[135674, 4311, 402, 10, 50, "Text"],

Cell[CellGroupData[{
Cell[136101, 4325, 128, 3, 30, "Input"],
Cell[136232, 4330, 502, 12, 59, "Output"]
}, Open  ]],
Cell[136749, 4345, 246, 7, 32, "Text"],
Cell[136998, 4354, 180, 5, 32, "Text"],
Cell[137181, 4361, 88, 3, 30, "Input"],
Cell[137272, 4366, 954, 24, 41, "Input"],

Cell[CellGroupData[{
Cell[138251, 4394, 123, 3, 30, "Input"],
Cell[138377, 4399, 313, 9, 29, "Output"]
}, Open  ]],
Cell[138705, 4411, 1129, 32, 68, "Text"],
Cell[139837, 4445, 130, 3, 30, "Input"],

Cell[CellGroupData[{
Cell[139992, 4452, 165, 4, 30, "Input"],
Cell[140160, 4458, 117, 3, 29, "Output"]
}, Open  ]],
Cell[140292, 4464, 153, 5, 32, "Text"],

Cell[CellGroupData[{
Cell[140470, 4473, 119, 3, 30, "Input"],
Cell[140592, 4478, 117, 3, 29, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[140770, 4488, 119, 2, 46, "Subsection"],
Cell[140892, 4492, 1014, 27, 104, "Text"],

Cell[CellGroupData[{
Cell[141931, 4523, 87, 3, 30, "Input"],
Cell[142021, 4528, 761, 17, 232, "Print"]
}, Open  ]],
Cell[142797, 4548, 149, 5, 32, "Text"],

Cell[CellGroupData[{
Cell[142971, 4557, 89, 3, 30, "Input"],
Cell[143063, 4562, 153, 4, 25, "Print"]
}, Open  ]],
Cell[143231, 4569, 308, 11, 32, "Text"],

Cell[CellGroupData[{
Cell[143564, 4584, 102, 3, 30, "Input"],
Cell[143669, 4589, 217, 7, 29, "Output"]
}, Open  ]],
Cell[143901, 4599, 482, 9, 68, "Text"],
Cell[144386, 4610, 91, 3, 30, "Input"],
Cell[144480, 4615, 269, 6, 90, "Input"],
Cell[144752, 4623, 110, 2, 32, "Text"],

Cell[CellGroupData[{
Cell[144887, 4629, 106, 3, 30, "Input"],
Cell[144996, 4634, 104, 3, 29, "Output"]
}, Open  ]],
Cell[145115, 4640, 610, 21, 50, "Text"],
Cell[145728, 4663, 213, 5, 32, "Text"],
Cell[145944, 4670, 119, 3, 30, "Input"],
Cell[146066, 4675, 145, 4, 32, "Text"],

Cell[CellGroupData[{
Cell[146236, 4683, 87, 3, 30, "Input"],
Cell[146326, 4688, 84, 3, 29, "Output"]
}, Open  ]],
Cell[146425, 4694, 134, 4, 32, "Text"],

Cell[CellGroupData[{
Cell[146584, 4702, 115, 3, 30, "Input"],
Cell[146702, 4707, 165, 4, 25, "Message"],
Cell[146870, 4713, 165, 4, 25, "Message"],
Cell[147038, 4719, 165, 4, 25, "Message"],
Cell[147206, 4725, 216, 5, 43, "Message"]
}, Open  ]],
Cell[147437, 4733, 368, 7, 68, "Text"],
Cell[147808, 4742, 130, 3, 30, "Input"],

Cell[CellGroupData[{
Cell[147963, 4749, 120, 3, 30, "Input"],
Cell[148086, 4754, 117, 3, 29, "Output"]
}, Open  ]],
Cell[148218, 4760, 389, 14, 32, "Text"],
Cell[148610, 4776, 193, 4, 50, "Input"],

Cell[CellGroupData[{
Cell[148828, 4784, 126, 3, 30, "Input"],
Cell[148957, 4789, 119, 3, 29, "Output"]
}, Open  ]],
Cell[149091, 4795, 842, 28, 68, "Text"],

Cell[CellGroupData[{
Cell[149958, 4827, 89, 3, 30, "Input"],
Cell[150050, 4832, 135, 3, 29, "Output"]
}, Open  ]],
Cell[150200, 4838, 438, 11, 50, "Text"],
Cell[150641, 4851, 137, 3, 30, "Input"],

Cell[CellGroupData[{
Cell[150803, 4858, 114, 3, 30, "Input"],
Cell[150920, 4863, 301, 9, 29, "Output"]
}, Open  ]],
Cell[151236, 4875, 266, 10, 32, "Text"],
Cell[151505, 4887, 125, 3, 30, "Input"],

Cell[CellGroupData[{
Cell[151655, 4894, 125, 3, 30, "Input"],
Cell[151783, 4899, 108, 3, 29, "Output"]
}, Open  ]],
Cell[151906, 4905, 449, 14, 50, "Text"],
Cell[152358, 4921, 167, 4, 50, "Input"],

Cell[CellGroupData[{
Cell[152550, 4929, 110, 3, 30, "Input"],
Cell[152663, 4934, 94, 3, 41, "Output"]
}, Open  ]],
Cell[152772, 4940, 132, 4, 32, "Text"],

Cell[CellGroupData[{
Cell[152929, 4948, 114, 3, 30, "Input"],
Cell[153046, 4953, 96, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[153179, 4961, 115, 3, 30, "Input"],
Cell[153297, 4966, 96, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[153430, 4974, 116, 3, 30, "Input"],
Cell[153549, 4979, 96, 3, 29, "Output"]
}, Open  ]],
Cell[153660, 4985, 227, 7, 32, "Text"],

Cell[CellGroupData[{
Cell[153912, 4996, 133, 3, 30, "Input"],
Cell[154048, 5001, 102, 3, 31, "Output"]
}, Open  ]],
Cell[154165, 5007, 734, 21, 68, "Text"],
Cell[154902, 5030, 160, 4, 30, "Input"],

Cell[CellGroupData[{
Cell[155087, 5038, 109, 3, 30, "Input"],
Cell[155199, 5043, 93, 3, 29, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[155341, 5052, 89, 2, 46, "Subsection"],
Cell[155433, 5056, 1599, 67, 86, "Text"],
Cell[157035, 5125, 139, 4, 50, "Input"],

Cell[CellGroupData[{
Cell[157199, 5133, 92, 3, 30, "Input"],
Cell[157294, 5138, 87, 3, 29, "Output"]
}, Open  ]],
Cell[157396, 5144, 501, 17, 50, "Text"],

Cell[CellGroupData[{
Cell[157922, 5165, 138, 3, 30, "Input"],
Cell[158063, 5170, 101, 3, 29, "Output"]
}, Open  ]],
Cell[158179, 5176, 1592, 48, 140, "Text"],

Cell[CellGroupData[{
Cell[159796, 5228, 96, 3, 30, "Input"],
Cell[159895, 5233, 223, 7, 29, "Output"]
}, Open  ]],
Cell[160133, 5243, 1323, 50, 86, "Text"],

Cell[CellGroupData[{
Cell[161481, 5297, 103, 3, 30, "Input"],
Cell[161587, 5302, 83, 3, 29, "Output"]
}, Open  ]],
Cell[161685, 5308, 284, 8, 50, "Text"],

Cell[CellGroupData[{
Cell[161994, 5320, 105, 3, 30, "Input"],
Cell[162102, 5325, 85, 3, 29, "Output"]
}, Open  ]],
Cell[162202, 5331, 208, 5, 32, "Text"],
Cell[162413, 5338, 569, 23, 50, "Text"],

Cell[CellGroupData[{
Cell[163007, 5365, 136, 3, 30, "Input"],
Cell[163146, 5370, 350, 11, 43, "Output"]
}, Open  ]],
Cell[163511, 5384, 91, 3, 30, "Input"],
Cell[163605, 5389, 122, 3, 50, "Input"],
Cell[163730, 5394, 322, 14, 32, "Text"],

Cell[CellGroupData[{
Cell[164077, 5412, 126, 3, 30, "Input"],
Cell[164206, 5417, 313, 10, 29, "Output"]
}, Open  ]],
Cell[164534, 5430, 273, 12, 32, "Text"],

Cell[CellGroupData[{
Cell[164832, 5446, 112, 3, 30, "Input"],
Cell[164947, 5451, 107, 3, 29, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[165103, 5460, 88, 2, 46, "Subsection"],
Cell[165194, 5464, 508, 19, 50, "Text"],

Cell[CellGroupData[{
Cell[165727, 5487, 114, 2, 42, "Subsubsection"],
Cell[165844, 5491, 976, 37, 68, "Text"],
Cell[166823, 5530, 88, 3, 30, "Input"],

Cell[CellGroupData[{
Cell[166936, 5537, 126, 3, 30, "Input"],
Cell[167065, 5542, 112, 3, 29, "Output"]
}, Open  ]],
Cell[167192, 5548, 761, 29, 68, "Text"],
Cell[167956, 5579, 155, 4, 30, "Input"],

Cell[CellGroupData[{
Cell[168136, 5587, 116, 3, 30, "Input"],
Cell[168255, 5592, 284, 8, 42, "Output"]
}, Open  ]],
Cell[168554, 5603, 390, 9, 50, "Text"],

Cell[CellGroupData[{
Cell[168969, 5616, 147, 4, 50, "Input"],
Cell[169119, 5622, 99, 3, 29, "Output"]
}, Open  ]],
Cell[169233, 5628, 599, 18, 68, "Text"],
Cell[169835, 5648, 467, 19, 50, "Text"],

Cell[CellGroupData[{
Cell[170327, 5671, 116, 3, 30, "Input"],
Cell[170446, 5676, 102, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[170585, 5684, 111, 3, 30, "Input"],
Cell[170699, 5689, 107, 3, 41, "Output"]
}, Open  ]],
Cell[170821, 5695, 331, 13, 32, "Text"],

Cell[CellGroupData[{
Cell[171177, 5712, 98, 3, 30, "Input"],
Cell[171278, 5717, 111, 3, 29, "Output"]
}, Open  ]],
Cell[171404, 5723, 204, 7, 32, "Text"],

Cell[CellGroupData[{
Cell[171633, 5734, 98, 3, 30, "Input"],
Cell[171734, 5739, 116, 3, 43, "Output"]
}, Open  ]],
Cell[171865, 5745, 154, 5, 32, "Text"],

Cell[CellGroupData[{
Cell[172044, 5754, 98, 3, 30, "Input"],
Cell[172145, 5759, 116, 3, 43, "Output"]
}, Open  ]],
Cell[172276, 5765, 703, 25, 68, "Text"],

Cell[CellGroupData[{
Cell[173004, 5794, 116, 3, 30, "Input"],
Cell[173123, 5799, 121, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[173281, 5807, 125, 3, 30, "Input"],
Cell[173409, 5812, 125, 3, 29, "Output"]
}, Open  ]],
Cell[173549, 5818, 281, 6, 50, "Text"],

Cell[CellGroupData[{
Cell[173855, 5828, 124, 3, 30, "Input"],
Cell[173982, 5833, 108, 3, 29, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[174139, 5842, 85, 2, 42, "Subsubsection"],
Cell[174227, 5846, 578, 26, 32, "Text"],

Cell[CellGroupData[{
Cell[174830, 5876, 101, 3, 30, "Input"],
Cell[174934, 5881, 209, 7, 29, "Output"]
}, Open  ]],
Cell[175158, 5891, 258, 10, 32, "Text"],

Cell[CellGroupData[{
Cell[175441, 5905, 133, 3, 30, "Input"],
Cell[175577, 5910, 99, 3, 29, "Output"]
}, Open  ]],
Cell[175691, 5916, 520, 25, 32, "Text"],

Cell[CellGroupData[{
Cell[176236, 5945, 135, 3, 30, "Input"],
Cell[176374, 5950, 121, 3, 29, "Output"]
}, Open  ]],
Cell[176510, 5956, 132, 4, 32, "Text"],

Cell[CellGroupData[{
Cell[176667, 5964, 166, 4, 50, "Input"],
Cell[176836, 5970, 102, 3, 41, "Output"]
}, Open  ]],
Cell[176953, 5976, 556, 14, 68, "Text"],
Cell[177512, 5992, 307, 9, 50, "Text"],
Cell[177822, 6003, 780, 21, 30, "Input"],
Cell[178605, 6026, 278, 7, 72, "Input"],

Cell[CellGroupData[{
Cell[178908, 6037, 101, 3, 30, "Input"],
Cell[179012, 6042, 713, 21, 29, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[179786, 6070, 88, 2, 46, "Subsection"],
Cell[179877, 6074, 718, 33, 50, "Text"],

Cell[CellGroupData[{
Cell[180620, 6111, 107, 3, 31, "Input"],
Cell[180730, 6116, 121, 3, 32, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[180888, 6124, 111, 3, 31, "Input"],
Cell[181002, 6129, 178, 4, 32, "Output"]
}, Open  ]],
Cell[181195, 6136, 120, 2, 32, "Text"],

Cell[CellGroupData[{
Cell[181340, 6142, 108, 3, 30, "Input"],
Cell[181451, 6147, 115, 3, 58, "Output"]
}, Open  ]],
Cell[181581, 6153, 555, 17, 68, "Text"],

Cell[CellGroupData[{
Cell[182161, 6174, 144, 4, 30, "Input"],
Cell[182308, 6180, 157, 4, 29, "Output"]
}, Open  ]],
Cell[182480, 6187, 345, 13, 32, "Text"],

Cell[CellGroupData[{
Cell[182850, 6204, 150, 4, 30, "Input"],
Cell[183003, 6210, 102, 3, 29, "Output"]
}, Open  ]],
Cell[183120, 6216, 390, 16, 32, "Text"],

Cell[CellGroupData[{
Cell[183535, 6236, 101, 3, 30, "Input"],
Cell[183639, 6241, 100, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[183776, 6249, 105, 3, 30, "Input"],
Cell[183884, 6254, 129, 3, 29, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

